/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.artifacts;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerProjectExtension;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactProperties;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.ArtifactRootElement;
import com.intellij.packaging.elements.ComplexPackagingElement;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.artifacts.PackagingElementPath;
import com.intellij.packaging.impl.artifacts.PackagingElementProcessor;
import com.intellij.packaging.impl.artifacts.ParentElementProcessor;
import com.intellij.packaging.impl.elements.ArtifactElementType;
import com.intellij.packaging.impl.elements.ArtifactPackagingElement;
import com.intellij.packaging.impl.elements.DirectoryCopyPackagingElement;
import com.intellij.packaging.impl.elements.DirectoryPackagingElement;
import com.intellij.packaging.impl.elements.FileCopyPackagingElement;
import com.intellij.packaging.impl.elements.FileOrDirectoryCopyPackagingElement;
import com.intellij.packaging.impl.elements.ModuleOutputPackagingElement;
import com.intellij.packaging.impl.elements.PackagingElementFactoryImpl;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactUtil {
    private ArtifactUtil() {
    }

    public static CompositePackagingElement<?> copyFromRoot(@NotNull CompositePackagingElement<?> oldRoot, @NotNull Project project) {
        if (oldRoot == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil.copyFromRoot must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil.copyFromRoot must not be null");
        }
        CompositePackagingElement newRoot = (CompositePackagingElement)ArtifactUtil.copyElement(oldRoot, project);
        ArtifactUtil.copyChildren(oldRoot, newRoot, project);
        return newRoot;
    }

    public static void copyChildren(CompositePackagingElement<?> oldParent, CompositePackagingElement<?> newParent, @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil.copyChildren must not be null");
        }
        for (PackagingElement child : oldParent.getChildren()) {
            newParent.addOrFindChild(ArtifactUtil.copyWithChildren(child, project));
        }
    }

    @NotNull
    public static <S> PackagingElement<S> copyWithChildren(@NotNull PackagingElement<S> element, @NotNull Project project) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil.copyWithChildren must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil.copyWithChildren must not be null");
        }
        PackagingElement<S> copy = ArtifactUtil.copyElement(element, project);
        if (element instanceof CompositePackagingElement) {
            ArtifactUtil.copyChildren((CompositePackagingElement)element, (CompositePackagingElement)copy, project);
        }
        PackagingElement<S> packagingElement = copy;
        if (packagingElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/packaging/impl/artifacts/ArtifactUtil.copyWithChildren must not return null");
        }
        return packagingElement;
    }

    @NotNull
    private static <S> PackagingElement<S> copyElement(@NotNull PackagingElement<S> element, @NotNull Project project) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil.copyElement must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil.copyElement must not be null");
        }
        PackagingElement copy = element.getType().createEmpty(project);
        copy.loadState(element.getState());
        PackagingElement packagingElement = copy;
        if (packagingElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/packaging/impl/artifacts/ArtifactUtil.copyElement must not return null");
        }
        return packagingElement;
    }

    public static <E extends PackagingElement<?>> boolean processPackagingElements(@NotNull Artifact artifact, @Nullable PackagingElementType<E> type, final @NotNull Processor<? super E> processor, @NotNull PackagingElementResolvingContext resolvingContext, boolean processSubstitutions) {
        if (artifact == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil.processPackagingElements must not be null");
        }
        if (processor == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil.processPackagingElements must not be null");
        }
        if (resolvingContext == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil.processPackagingElements must not be null");
        }
        return ArtifactUtil.processPackagingElements(artifact, type, new PackagingElementProcessor<E>(){

            @Override
            public boolean process(@NotNull E e, @NotNull PackagingElementPath path) {
                if (e == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil$1.process must not be null");
                }
                if (path == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil$1.process must not be null");
                }
                return processor.process(e);
            }
        }, resolvingContext, processSubstitutions);
    }

    public static <E extends PackagingElement<?>> boolean processPackagingElements(@NotNull Artifact artifact, @Nullable PackagingElementType<E> type, @NotNull PackagingElementProcessor<? super E> processor, @NotNull PackagingElementResolvingContext resolvingContext, boolean processSubstitutions) {
        if (artifact == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil.processPackagingElements must not be null");
        }
        if (processor == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil.processPackagingElements must not be null");
        }
        if (resolvingContext == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil.processPackagingElements must not be null");
        }
        return ArtifactUtil.processPackagingElements(artifact.getRootElement(), type, processor, resolvingContext, processSubstitutions, artifact.getArtifactType());
    }

    public static <E extends PackagingElement<?>> boolean processPackagingElements(PackagingElement<?> rootElement, @Nullable PackagingElementType<E> type, @NotNull PackagingElementProcessor<? super E> processor, @NotNull PackagingElementResolvingContext resolvingContext, boolean processSubstitutions, ArtifactType artifactType) {
        if (processor == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil.processPackagingElements must not be null");
        }
        if (resolvingContext == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil.processPackagingElements must not be null");
        }
        return ArtifactUtil.processElementRecursively(rootElement, type, processor, resolvingContext, processSubstitutions, artifactType, PackagingElementPath.EMPTY, new HashSet());
    }

    private static <E extends PackagingElement<?>> boolean processElementsRecursively(List<? extends PackagingElement<?>> elements, @Nullable PackagingElementType<E> type, @NotNull PackagingElementProcessor<? super E> processor, @NotNull PackagingElementResolvingContext resolvingContext, boolean processSubstitutions, ArtifactType artifactType, @NotNull PackagingElementPath path, Set<PackagingElement<?>> processed) {
        if (processor == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil.processElementsRecursively must not be null");
        }
        if (resolvingContext == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil.processElementsRecursively must not be null");
        }
        if (path == null) {
            throw new IllegalArgumentException("Argument 6 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil.processElementsRecursively must not be null");
        }
        for (PackagingElement<?> element : elements) {
            if (ArtifactUtil.processElementRecursively(element, type, processor, resolvingContext, processSubstitutions, artifactType, path, processed)) continue;
            return false;
        }
        return true;
    }

    private static <E extends PackagingElement<?>> boolean processElementRecursively(@NotNull PackagingElement<?> element, @Nullable PackagingElementType<E> type, @NotNull PackagingElementProcessor<? super E> processor, @NotNull PackagingElementResolvingContext resolvingContext, boolean processSubstitutions, ArtifactType artifactType, @NotNull PackagingElementPath path, Set<PackagingElement<?>> processed) {
        List substitution;
        ComplexPackagingElement complexElement;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil.processElementRecursively must not be null");
        }
        if (processor == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil.processElementRecursively must not be null");
        }
        if (resolvingContext == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil.processElementRecursively must not be null");
        }
        if (path == null) {
            throw new IllegalArgumentException("Argument 6 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil.processElementRecursively must not be null");
        }
        if (!processor.shouldProcess(element) || !processed.add(element)) {
            return true;
        }
        if ((type == null || element.getType().equals(type)) && !processor.process(element, path)) {
            return false;
        }
        if (element instanceof CompositePackagingElement) {
            CompositePackagingElement composite = (CompositePackagingElement)element;
            return ArtifactUtil.processElementsRecursively(composite.getChildren(), type, processor, resolvingContext, processSubstitutions, artifactType, path.appendComposite(composite), processed);
        }
        if (element instanceof ComplexPackagingElement && processSubstitutions && processor.shouldProcessSubstitution(complexElement = (ComplexPackagingElement)element) && (substitution = complexElement.getSubstitution(resolvingContext, artifactType)) != null) {
            return ArtifactUtil.processElementsRecursively(substitution, type, processor, resolvingContext, processSubstitutions, artifactType, path.appendComplex(complexElement), processed);
        }
        return true;
    }

    public static void removeDuplicates(@NotNull CompositePackagingElement<?> parent) {
        if (parent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil.removeDuplicates must not be null");
        }
        ArrayList<PackagingElement> prevChildren = new ArrayList<PackagingElement>();
        ArrayList<PackagingElement> toRemove = new ArrayList<PackagingElement>();
        for (PackagingElement child : parent.getChildren()) {
            if (child instanceof CompositePackagingElement) {
                ArtifactUtil.removeDuplicates((CompositePackagingElement)child);
            }
            boolean merged = false;
            for (PackagingElement prevChild : prevChildren) {
                if (!child.isEqualTo(prevChild)) continue;
                if (child instanceof CompositePackagingElement) {
                    for (PackagingElement childElement : ((CompositePackagingElement)child).getChildren()) {
                        ((CompositePackagingElement)prevChild).addOrFindChild(childElement);
                    }
                }
                merged = true;
                break;
            }
            if (merged) {
                toRemove.add(child);
                continue;
            }
            prevChildren.add(child);
        }
        for (PackagingElement child : toRemove) {
            parent.removeChild(child);
        }
    }

    public static <S> void copyProperties(ArtifactProperties<?> from, ArtifactProperties<S> to) {
        to.loadState(from.getState());
    }

    @Nullable
    public static String getDefaultArtifactOutputPath(@NotNull String artifactName, @NotNull Project project) {
        if (artifactName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil.getDefaultArtifactOutputPath must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil.getDefaultArtifactOutputPath must not be null");
        }
        CompilerProjectExtension extension = CompilerProjectExtension.getInstance((Project)project);
        if (extension == null) {
            return null;
        }
        String outputUrl = extension.getCompilerOutputUrl();
        if (outputUrl == null || outputUrl.length() == 0) {
            VirtualFile baseDir = project.getBaseDir();
            if (baseDir == null) {
                return null;
            }
            outputUrl = baseDir.getUrl() + "/out";
        }
        return VfsUtil.urlToPath((String)outputUrl) + "/artifacts/" + FileUtil.sanitizeFileName((String)artifactName);
    }

    public static <E extends PackagingElement<?>> boolean processElementsWithSubstitutions(@NotNull List<? extends PackagingElement<?>> elements, @NotNull PackagingElementResolvingContext context, @NotNull ArtifactType artifactType, @NotNull PackagingElementPath parentPath, @NotNull PackagingElementProcessor<E> processor) {
        if (elements == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil.processElementsWithSubstitutions must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil.processElementsWithSubstitutions must not be null");
        }
        if (artifactType == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil.processElementsWithSubstitutions must not be null");
        }
        if (parentPath == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil.processElementsWithSubstitutions must not be null");
        }
        if (processor == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil.processElementsWithSubstitutions must not be null");
        }
        return ArtifactUtil.processElementsWithSubstitutions(elements, context, artifactType, parentPath, processor, new HashSet());
    }

    private static <E extends PackagingElement<?>> boolean processElementsWithSubstitutions(@NotNull List<? extends PackagingElement<?>> elements, @NotNull PackagingElementResolvingContext context, @NotNull ArtifactType artifactType, @NotNull PackagingElementPath parentPath, @NotNull PackagingElementProcessor<E> processor, Set<PackagingElement<?>> processed) {
        if (elements == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil.processElementsWithSubstitutions must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil.processElementsWithSubstitutions must not be null");
        }
        if (artifactType == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil.processElementsWithSubstitutions must not be null");
        }
        if (parentPath == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil.processElementsWithSubstitutions must not be null");
        }
        if (processor == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil.processElementsWithSubstitutions must not be null");
        }
        for (PackagingElement<?> element : elements) {
            ComplexPackagingElement complexElement;
            List substitution;
            if (!processed.add(element) || !(element instanceof ComplexPackagingElement && processor.shouldProcessSubstitution((ComplexPackagingElement)element) ? (substitution = (complexElement = (ComplexPackagingElement)element).getSubstitution(context, artifactType)) != null && !ArtifactUtil.processElementsWithSubstitutions(substitution, context, artifactType, parentPath.appendComplex(complexElement), processor, processed) : !processor.process(element, parentPath))) continue;
            return false;
        }
        return true;
    }

    public static List<PackagingElement<?>> findByRelativePath(@NotNull CompositePackagingElement<?> parent, @NotNull String relativePath, @NotNull PackagingElementResolvingContext context, @NotNull ArtifactType artifactType) {
        if (parent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil.findByRelativePath must not be null");
        }
        if (relativePath == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil.findByRelativePath must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil.findByRelativePath must not be null");
        }
        if (artifactType == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil.findByRelativePath must not be null");
        }
        final ArrayList result = new ArrayList();
        ArtifactUtil.processElementsByRelativePath(parent, relativePath, context, artifactType, PackagingElementPath.EMPTY, new PackagingElementProcessor<PackagingElement<?>>(){

            @Override
            public boolean process(@NotNull PackagingElement<?> packagingElement, @NotNull PackagingElementPath path) {
                if (packagingElement == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil$2.process must not be null");
                }
                if (path == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil$2.process must not be null");
                }
                result.add(packagingElement);
                return true;
            }
        });
        return result;
    }

    public static boolean processElementsByRelativePath(@NotNull CompositePackagingElement<?> parent, @NotNull String relativePath, final @NotNull PackagingElementResolvingContext context, final @NotNull ArtifactType artifactType, @NotNull PackagingElementPath parentPath, final @NotNull PackagingElementProcessor<PackagingElement<?>> processor) {
        if (parent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil.processElementsByRelativePath must not be null");
        }
        if (relativePath == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil.processElementsByRelativePath must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil.processElementsByRelativePath must not be null");
        }
        if (artifactType == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil.processElementsByRelativePath must not be null");
        }
        if (parentPath == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil.processElementsByRelativePath must not be null");
        }
        if (processor == null) {
            throw new IllegalArgumentException("Argument 5 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil.processElementsByRelativePath must not be null");
        }
        if ((relativePath = StringUtil.trimStart((String)relativePath, (String)"/")).length() == 0) {
            return true;
        }
        int i = relativePath.indexOf(47);
        final String firstName = i != -1 ? relativePath.substring(0, i) : relativePath;
        final String tail = i != -1 ? relativePath.substring(i + 1) : "";
        return ArtifactUtil.processElementsWithSubstitutions(parent.getChildren(), context, artifactType, parentPath.appendComposite(parent), new PackagingElementProcessor<PackagingElement<?>>(){

            @Override
            public boolean process(@NotNull PackagingElement<?> element, @NotNull PackagingElementPath path) {
                FileCopyPackagingElement fileCopy;
                if (element == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil$3.process must not be null");
                }
                if (path == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil$3.process must not be null");
                }
                boolean process = false;
                if (element instanceof CompositePackagingElement && firstName.equals(((CompositePackagingElement)element).getName())) {
                    process = true;
                } else if (element instanceof FileCopyPackagingElement && firstName.equals((fileCopy = (FileCopyPackagingElement)element).getOutputFileName())) {
                    process = true;
                }
                if (process) {
                    if (tail.length() == 0) {
                        if (!processor.process(element, path)) {
                            return false;
                        }
                    } else if (element instanceof CompositePackagingElement) {
                        return ArtifactUtil.processElementsByRelativePath((CompositePackagingElement)element, tail, context, artifactType, path, processor);
                    }
                }
                return true;
            }
        });
    }

    public static boolean processDirectoryChildren(@NotNull CompositePackagingElement<?> parent, @NotNull PackagingElementPath pathToParent, @NotNull String relativePath, final @NotNull PackagingElementResolvingContext context, final @NotNull ArtifactType artifactType, final @NotNull PackagingElementProcessor<PackagingElement<?>> processor) {
        if (parent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil.processDirectoryChildren must not be null");
        }
        if (pathToParent == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil.processDirectoryChildren must not be null");
        }
        if (relativePath == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil.processDirectoryChildren must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil.processDirectoryChildren must not be null");
        }
        if (artifactType == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil.processDirectoryChildren must not be null");
        }
        if (processor == null) {
            throw new IllegalArgumentException("Argument 5 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil.processDirectoryChildren must not be null");
        }
        return ArtifactUtil.processElementsByRelativePath(parent, relativePath, context, artifactType, pathToParent, new PackagingElementProcessor<PackagingElement<?>>(){

            @Override
            public boolean process(@NotNull PackagingElement<?> element, @NotNull PackagingElementPath path) {
                List children;
                if (element == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil$4.process must not be null");
                }
                if (path == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil$4.process must not be null");
                }
                return !(element instanceof DirectoryPackagingElement) || ArtifactUtil.processElementsWithSubstitutions(children = ((DirectoryPackagingElement)element).getChildren(), context, artifactType, path.appendComposite((DirectoryPackagingElement)element), processor);
            }
        });
    }

    public static void processFileOrDirectoryCopyElements(Artifact artifact, PackagingElementProcessor<FileOrDirectoryCopyPackagingElement<?>> processor, PackagingElementResolvingContext context, boolean processSubstitutions) {
        ArtifactUtil.processPackagingElements(artifact, PackagingElementFactoryImpl.FILE_COPY_ELEMENT_TYPE, processor, context, processSubstitutions);
        ArtifactUtil.processPackagingElements(artifact, PackagingElementFactoryImpl.DIRECTORY_COPY_ELEMENT_TYPE, processor, context, processSubstitutions);
    }

    public static Collection<Trinity<Artifact, PackagingElementPath, String>> findContainingArtifactsWithOutputPaths(final @NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil.findContainingArtifactsWithOutputPaths must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil.findContainingArtifactsWithOutputPaths must not be null");
        }
        final boolean isResourceFile = CompilerConfiguration.getInstance((Project)project).isResourceFile(file);
        final ArrayList<Trinity<Artifact, PackagingElementPath, String>> artifacts = new ArrayList<Trinity<Artifact, PackagingElementPath, String>>();
        final PackagingElementResolvingContext context = ArtifactManager.getInstance((Project)project).getResolvingContext();
        for (final Artifact artifact : ArtifactManager.getInstance((Project)project).getArtifacts()) {
            ArtifactUtil.processPackagingElements(artifact, null, new PackagingElementProcessor<PackagingElement<?>>(){

                @Override
                public boolean process(@NotNull PackagingElement<?> element, @NotNull PackagingElementPath path) {
                    String relativePath;
                    if (element == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil$5.process must not be null");
                    }
                    if (path == null) {
                        throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil$5.process must not be null");
                    }
                    if (element instanceof FileOrDirectoryCopyPackagingElement) {
                        VirtualFile root = ((FileOrDirectoryCopyPackagingElement)element).findFile();
                        if (root != null && VfsUtil.isAncestor((VirtualFile)root, (VirtualFile)file, (boolean)false)) {
                            String relativePath2 = root.equals(file) && element instanceof FileCopyPackagingElement ? ((FileCopyPackagingElement)element).getOutputFileName() : VfsUtil.getRelativePath((VirtualFile)file, (VirtualFile)root, (char)'/');
                            artifacts.add(Trinity.create((Object)artifact, (Object)path, (Object)relativePath2));
                            return false;
                        }
                    } else if (isResourceFile && element instanceof ModuleOutputPackagingElement && (relativePath = ArtifactUtil.getRelativePathInSources(file, (ModuleOutputPackagingElement)element, context)) != null) {
                        artifacts.add(Trinity.create((Object)artifact, (Object)path, (Object)relativePath));
                        return false;
                    }
                    return true;
                }
            }, context, true);
        }
        return artifacts;
    }

    @Nullable
    private static String getRelativePathInSources(@NotNull VirtualFile file, @NotNull ModuleOutputPackagingElement moduleElement, @NotNull PackagingElementResolvingContext context) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil.getRelativePathInSources must not be null");
        }
        if (moduleElement == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil.getRelativePathInSources must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil.getRelativePathInSources must not be null");
        }
        Module module = moduleElement.findModule(context);
        if (module != null) {
            ModuleRootModel rootModel = context.getModulesProvider().getRootModel(module);
            for (ContentEntry entry : rootModel.getContentEntries()) {
                for (SourceFolder folder : entry.getSourceFolders()) {
                    VirtualFile sourceRoot = folder.getFile();
                    if (folder.isTestSource() || sourceRoot == null || !VfsUtil.isAncestor((VirtualFile)sourceRoot, (VirtualFile)file, (boolean)true)) continue;
                    return VfsUtil.getRelativePath((VirtualFile)file, (VirtualFile)sourceRoot, (char)'/');
                }
            }
        }
        return null;
    }

    @Nullable
    public static VirtualFile findSourceFileByOutputPath(Artifact artifact, String outputPath, PackagingElementResolvingContext context) {
        List<VirtualFile> files = ArtifactUtil.findSourceFilesByOutputPath(artifact.getRootElement(), outputPath, context, artifact.getArtifactType());
        return files.isEmpty() ? null : files.get(0);
    }

    @Nullable
    public static VirtualFile findSourceFileByOutputPath(CompositePackagingElement<?> parent, String outputPath, PackagingElementResolvingContext context, ArtifactType artifactType) {
        List<VirtualFile> files = ArtifactUtil.findSourceFilesByOutputPath(parent, outputPath, context, artifactType);
        return files.isEmpty() ? null : files.get(0);
    }

    public static List<VirtualFile> findSourceFilesByOutputPath(CompositePackagingElement<?> parent, String outputPath, PackagingElementResolvingContext context, ArtifactType artifactType) {
        String path = StringUtil.trimStart((String)outputPath, (String)"/");
        if (path.length() == 0) {
            return Collections.emptyList();
        }
        int i = path.indexOf(47);
        final String firstName = i != -1 ? path.substring(0, i) : path;
        String tail = i != -1 ? path.substring(i + 1) : "";
        SmartList result = new SmartList();
        ArtifactUtil.processElementsWithSubstitutions(parent.getChildren(), context, artifactType, PackagingElementPath.EMPTY, new PackagingElementProcessor<PackagingElement<?>>((List)result, tail, context, artifactType, path){
            final /* synthetic */ List val$result;
            final /* synthetic */ String val$tail;
            final /* synthetic */ PackagingElementResolvingContext val$context;
            final /* synthetic */ ArtifactType val$artifactType;
            final /* synthetic */ String val$path;
            {
                this.val$result = list;
                this.val$tail = string2;
                this.val$context = packagingElementResolvingContext;
                this.val$artifactType = artifactType;
                this.val$path = string3;
            }

            @Override
            public boolean process(@NotNull PackagingElement<?> element, @NotNull PackagingElementPath elementPath) {
                Module module;
                if (element == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil$6.process must not be null");
                }
                if (elementPath == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil$6.process must not be null");
                }
                if (element instanceof CompositePackagingElement) {
                    CompositePackagingElement compositeElement = (CompositePackagingElement)element;
                    if (firstName.equals(compositeElement.getName())) {
                        this.val$result.addAll(ArtifactUtil.findSourceFilesByOutputPath(compositeElement, this.val$tail, this.val$context, this.val$artifactType));
                    }
                } else if (element instanceof FileCopyPackagingElement) {
                    FileCopyPackagingElement fileCopyElement = (FileCopyPackagingElement)element;
                    if (firstName.equals(fileCopyElement.getOutputFileName()) && this.val$tail.length() == 0) {
                        ContainerUtil.addIfNotNull((Object)fileCopyElement.findFile(), (Collection)this.val$result);
                    }
                } else if (element instanceof DirectoryCopyPackagingElement) {
                    VirtualFile sourceRoot = ((DirectoryCopyPackagingElement)element).findFile();
                    if (sourceRoot != null) {
                        ContainerUtil.addIfNotNull((Object)sourceRoot.findFileByRelativePath(this.val$path), (Collection)this.val$result);
                    }
                } else if (element instanceof ModuleOutputPackagingElement && (module = ((ModuleOutputPackagingElement)element).findModule(this.val$context)) != null) {
                    ContentEntry[] contentEntries;
                    CompilerConfiguration compilerConfiguration = CompilerConfiguration.getInstance((Project)this.val$context.getProject());
                    for (ContentEntry contentEntry : contentEntries = this.val$context.getModulesProvider().getRootModel(module).getContentEntries()) {
                        for (SourceFolder sourceFolder : contentEntry.getSourceFolders()) {
                            VirtualFile sourceFile;
                            VirtualFile sourceRoot = sourceFolder.getFile();
                            if (sourceFolder.isTestSource() || sourceRoot == null || (sourceFile = sourceRoot.findFileByRelativePath(this.val$path)) == null || !compilerConfiguration.isResourceFile(sourceFile)) continue;
                            this.val$result.add(sourceFile);
                        }
                    }
                }
                return true;
            }
        });
        return result;
    }

    public static boolean processParents(@NotNull Artifact artifact, @NotNull PackagingElementResolvingContext context, @NotNull ParentElementProcessor processor, int maxLevel) {
        if (artifact == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil.processParents must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil.processParents must not be null");
        }
        if (processor == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil.processParents must not be null");
        }
        return ArtifactUtil.processParents(artifact, context, processor, FList.emptyList(), maxLevel, new HashSet<Artifact>());
    }

    private static boolean processParents(final @NotNull Artifact artifact, final @NotNull PackagingElementResolvingContext context, final @NotNull ParentElementProcessor processor, FList<Pair<Artifact, CompositePackagingElement<?>>> pathToElement, final int maxLevel, final Set<Artifact> processed) {
        FList pathFromRoot;
        if (artifact == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil.processParents must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil.processParents must not be null");
        }
        if (processor == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil.processParents must not be null");
        }
        if (!processed.add(artifact)) {
            return true;
        }
        CompositePackagingElement rootElement = artifact.getRootElement();
        if (rootElement instanceof ArtifactRootElement) {
            pathFromRoot = pathToElement;
        } else {
            if (!processor.process((CompositePackagingElement<?>)rootElement, (List<Pair<Artifact, CompositePackagingElement<?>>>)pathToElement, artifact)) {
                return false;
            }
            pathFromRoot = pathToElement.prepend((Object)new Pair((Object)artifact, (Object)rootElement));
        }
        if (pathFromRoot.size() > maxLevel) {
            return true;
        }
        for (final Artifact anArtifact : context.getArtifactModel().getArtifacts()) {
            PackagingElementProcessor<ArtifactPackagingElement> elementProcessor;
            if (processed.contains(anArtifact) || ArtifactUtil.processPackagingElements(anArtifact, ArtifactElementType.ARTIFACT_ELEMENT_TYPE, elementProcessor = new PackagingElementProcessor<ArtifactPackagingElement>(){

                @Override
                public boolean shouldProcessSubstitution(ComplexPackagingElement<?> element) {
                    return !(element instanceof ArtifactPackagingElement);
                }

                @Override
                public boolean process(@NotNull ArtifactPackagingElement element, @NotNull PackagingElementPath path) {
                    if (element == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil$7.process must not be null");
                    }
                    if (path == null) {
                        throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil$7.process must not be null");
                    }
                    if (artifact.getName().equals(element.getArtifactName())) {
                        CompositePackagingElement<?> lastParent;
                        FList currentPath = pathFromRoot;
                        List<CompositePackagingElement<?>> parents = path.getParents();
                        int parentsSize = parents.size();
                        for (int i = 0; i < parentsSize - 1; ++i) {
                            CompositePackagingElement<?> parent = parents.get(i);
                            if (!processor.process(parent, (List<Pair<Artifact, CompositePackagingElement<?>>>)currentPath, anArtifact)) {
                                return false;
                            }
                            if ((currentPath = currentPath.prepend((Object)new Pair((Object)anArtifact, parent))).size() <= maxLevel) continue;
                            return true;
                        }
                        if (!parents.isEmpty() && (lastParent = parents.get(parents.size() - 1)) instanceof ArtifactRootElement && !processor.process(lastParent, (List<Pair<Artifact, CompositePackagingElement<?>>>)currentPath, anArtifact)) {
                            return false;
                        }
                        return ArtifactUtil.processParents(anArtifact, context, processor, currentPath, maxLevel, processed);
                    }
                    return true;
                }
            }, context, true)) continue;
            return false;
        }
        return true;
    }

    public static boolean isArchiveName(String name) {
        return name.length() >= 4 && name.charAt(name.length() - 4) == '.' && StringUtil.endsWithIgnoreCase((String)name, (String)"ar");
    }

    public static void removeChildrenRecursively(@NotNull CompositePackagingElement<?> element, @NotNull Condition<PackagingElement<?>> condition) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil.removeChildrenRecursively must not be null");
        }
        if (condition == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactUtil.removeChildrenRecursively must not be null");
        }
        ArrayList<PackagingElement> toRemove = new ArrayList<PackagingElement>();
        for (PackagingElement child : element.getChildren()) {
            if (child instanceof CompositePackagingElement) {
                CompositePackagingElement compositeChild = (CompositePackagingElement)child;
                ArtifactUtil.removeChildrenRecursively(compositeChild, condition);
                if (!compositeChild.getChildren().isEmpty()) continue;
                toRemove.add(child);
                continue;
            }
            if (!condition.value((Object)child)) continue;
            toRemove.add(child);
        }
        element.removeChildren(toRemove);
    }

    public static boolean shouldClearArtifactOutputBeforeRebuild(Artifact artifact) {
        String outputPath = artifact.getOutputPath();
        return !StringUtil.isEmpty((String)outputPath) && artifact.getRootElement() instanceof ArtifactRootElement;
    }
}

