/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.include;

import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.include.FileIncludeIndex;
import com.intellij.psi.impl.include.FileIncludeInfoImpl;
import com.intellij.psi.impl.include.FileIncludeManager;
import com.intellij.psi.impl.include.FileIncludeProvider;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FileIncludeManagerImpl
extends FileIncludeManager {
    private final Project myProject;
    private final PsiManager myPsiManager;
    private final PsiFileFactory myPsiFileFactory;
    private final Map<String, FileIncludeProvider> myProviderMap;
    private final CachedValuesManager myCachedValuesManager;
    private final IncludeCacheHolder myIncludedHolder = new IncludeCacheHolder("compile time includes", "runtime includes"){

        @Override
        protected VirtualFile[] computeFiles(PsiFile file, boolean compileTimeOnly) {
            GlobalSearchScope scope = GlobalSearchScope.allScope((Project)FileIncludeManagerImpl.this.myProject);
            List<FileIncludeInfoImpl> infoList = FileIncludeIndex.getIncludes(file.getVirtualFile(), scope);
            ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
            for (FileIncludeInfoImpl info : infoList) {
                PsiFileSystemItem virtualFile;
                FileIncludeProvider includeProvider;
                if (compileTimeOnly && info.runtimeOnly || (includeProvider = (FileIncludeProvider)FileIncludeManagerImpl.this.myProviderMap.get(info.providerId)) == null || (virtualFile = includeProvider.resolveInclude(info, file, FileIncludeManagerImpl.this.myProject)) == null) continue;
                files.add(virtualFile.getVirtualFile());
            }
            return VfsUtil.toVirtualFileArray(files);
        }
    };
    private final IncludeCacheHolder myIncludingHolder = new IncludeCacheHolder("compile time contexts", "runtime contexts"){

        @Override
        protected VirtualFile[] computeFiles(PsiFile file, boolean compileTimeOnly) {
            MultiMap<VirtualFile, FileIncludeInfoImpl> infoList = FileIncludeIndex.getIncludingFileCandidates(file.getName(), GlobalSearchScope.allScope((Project)FileIncludeManagerImpl.this.myProject));
            ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
            for (VirtualFile candidate : infoList.keySet()) {
                PsiFile psiFile = FileIncludeManagerImpl.this.myPsiManager.findFile(candidate);
                if (psiFile == null) continue;
                for (FileIncludeInfoImpl info : infoList.get((Object)candidate)) {
                    FileIncludeProvider includeProvider = (FileIncludeProvider)FileIncludeManagerImpl.this.myProviderMap.get(info.providerId);
                    if (includeProvider == null || !file.equals(includeProvider.resolveInclude(info, psiFile, FileIncludeManagerImpl.this.myProject))) continue;
                    files.add(candidate);
                }
            }
            return VfsUtil.toVirtualFileArray(files);
        }
    };

    public FileIncludeManagerImpl(Project project, PsiManager psiManager, PsiFileFactory psiFileFactory, CachedValuesManager cachedValuesManager) {
        this.myProject = project;
        this.myPsiManager = psiManager;
        this.myPsiFileFactory = psiFileFactory;
        FileIncludeProvider[] providers = (FileIncludeProvider[])Extensions.getExtensions(FileIncludeProvider.EP_NAME);
        this.myProviderMap = new HashMap(providers.length);
        for (FileIncludeProvider provider : providers) {
            FileIncludeProvider old = this.myProviderMap.put(provider.getId(), provider);
            assert (old == null);
        }
        this.myCachedValuesManager = cachedValuesManager;
    }

    public VirtualFile[] getIncludedFiles(VirtualFile file, boolean compileTimeOnly) {
        if (file instanceof VirtualFileWithId) {
            return this.myIncludedHolder.getAllFiles(file, compileTimeOnly);
        }
        return VirtualFile.EMPTY_ARRAY;
    }

    public VirtualFile[] getIncludingFiles(VirtualFile file, boolean compileTimeOnly) {
        return this.myIncludingHolder.getAllFiles(file, compileTimeOnly);
    }

    public PsiFileSystemItem resolveFileReference(String text, PsiFile context) {
        PsiFileImpl psiFile = (PsiFileImpl)this.myPsiFileFactory.createFileFromText("dummy.txt", text);
        psiFile.setOriginalFile(context);
        return new FileReferenceSet((PsiElement)psiFile).resolve();
    }

    private static abstract class IncludedFilesProvider
    implements ParameterizedCachedValueProvider<VirtualFile[], PsiFile> {
        private boolean myRuntimeOnly;

        public IncludedFilesProvider(boolean runtimeOnly) {
            this.myRuntimeOnly = runtimeOnly;
        }

        protected abstract VirtualFile[] computeFiles(PsiFile var1, boolean var2);

        public CachedValueProvider.Result<VirtualFile[]> compute(PsiFile param) {
            Object[] value = this.computeFiles(param, this.myRuntimeOnly);
            return CachedValueProvider.Result.create((Object)value, (Object[])ArrayUtil.append((Object[])value, (Object)param.getVirtualFile()));
        }
    }

    private abstract class IncludeCacheHolder {
        private final Key<ParameterizedCachedValue<VirtualFile[], PsiFile>> COMPILE_TIME_KEY;
        private final Key<ParameterizedCachedValue<VirtualFile[], PsiFile>> RUNTIME_KEY;
        private final ParameterizedCachedValueProvider<VirtualFile[], PsiFile> COMPILE_TIME_PROVIDER = new IncludedFilesProvider(false){

            @Override
            protected VirtualFile[] computeFiles(PsiFile file, boolean compileTimeOnly) {
                return IncludeCacheHolder.this.computeFiles(file, compileTimeOnly);
            }
        };
        private final ParameterizedCachedValueProvider<VirtualFile[], PsiFile> RUNTIME_PROVIDER = new IncludedFilesProvider(true){

            @Override
            protected VirtualFile[] computeFiles(PsiFile file, boolean compileTimeOnly) {
                return IncludeCacheHolder.this.computeFiles(file, compileTimeOnly);
            }
        };

        private IncludeCacheHolder(String compileTimeKey, String runtimeKey) {
            this.COMPILE_TIME_KEY = Key.create((String)compileTimeKey);
            this.RUNTIME_KEY = Key.create((String)runtimeKey);
        }

        public VirtualFile[] getAllFiles(VirtualFile file, boolean compileTimeOnly) {
            ArrayList<VirtualFile[]> result = new ArrayList<VirtualFile[]>();
            this.getFilesRecursively(file, compileTimeOnly, result);
            switch (result.size()) {
                case 0: {
                    return VirtualFile.EMPTY_ARRAY;
                }
                case 1: {
                    return result.get(0);
                }
            }
            int size = 0;
            for (VirtualFile[] files : result) {
                size += files.length;
            }
            VirtualFile[] files = new VirtualFile[size];
            int pos = 0;
            for (VirtualFile[] virtualFiles : result) {
                System.arraycopy(virtualFiles, 0, files, pos, virtualFiles.length);
                pos += virtualFiles.length;
            }
            return files;
        }

        private void getFilesRecursively(VirtualFile file, boolean compileTimeOnly, List<VirtualFile[]> result) {
            VirtualFile[] includes;
            PsiFile psiFile = FileIncludeManagerImpl.this.myPsiManager.findFile(file);
            if (psiFile == null) {
                return;
            }
            VirtualFile[] virtualFileArray = includes = compileTimeOnly ? (VirtualFile[])FileIncludeManagerImpl.this.myCachedValuesManager.getParameterizedCachedValue((UserDataHolder)psiFile, this.COMPILE_TIME_KEY, this.COMPILE_TIME_PROVIDER, false, (Object)psiFile) : (VirtualFile[])FileIncludeManagerImpl.this.myCachedValuesManager.getParameterizedCachedValue((UserDataHolder)psiFile, this.RUNTIME_KEY, this.RUNTIME_PROVIDER, false, (Object)psiFile);
            if (includes.length != 0) {
                result.add(includes);
                for (VirtualFile include : includes) {
                    this.getFilesRecursively(include, compileTimeOnly, result);
                }
            }
        }

        protected abstract VirtualFile[] computeFiles(PsiFile var1, boolean var2);
    }
}

