/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util.classMembers;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberDependencyGraph;
import com.intellij.refactoring.util.classMembers.ClassMembersUtil;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.util.containers.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class InterfaceMemberDependencyGraph
implements MemberDependencyGraph<PsiMember, MemberInfo> {
    protected HashSet<PsiMethod> myInterfaceDependencies = null;
    protected HashMap<PsiMethod, HashSet<PsiClass>> myMembersToInterfacesMap = new HashMap();
    protected HashSet<PsiClass> myImplementedInterfaces;
    protected HashMap<PsiClass, HashSet<PsiMethod>> myMethodsFromInterfaces;
    protected PsiClass myClass;

    public InterfaceMemberDependencyGraph(PsiClass aClass) {
        this.myClass = aClass;
        this.myImplementedInterfaces = new HashSet();
        this.myMethodsFromInterfaces = new HashMap();
    }

    public void memberChanged(MemberInfo memberInfo) {
        if (ClassMembersUtil.isImplementedInterface(memberInfo)) {
            PsiClass aClass = (PsiClass)memberInfo.getMember();
            this.myInterfaceDependencies = null;
            this.myMembersToInterfacesMap = null;
            if (memberInfo.isChecked()) {
                this.myImplementedInterfaces.add(aClass);
            } else {
                this.myImplementedInterfaces.remove(aClass);
            }
        }
    }

    public Set<? extends PsiMember> getDependent() {
        if (this.myInterfaceDependencies == null) {
            this.myInterfaceDependencies = new HashSet();
            this.myMembersToInterfacesMap = new HashMap();
            for (PsiClass implementedInterface : this.myImplementedInterfaces) {
                this.addInterfaceDeps(implementedInterface);
            }
        }
        return this.myInterfaceDependencies;
    }

    public Set<? extends PsiMember> getDependenciesOf(PsiMember member) {
        Set<? extends PsiMember> dependent = this.getDependent();
        if (dependent.contains(member)) {
            return (Set)this.myMembersToInterfacesMap.get((Object)member);
        }
        return null;
    }

    public String getElementTooltip(PsiMember member) {
        Set<? extends PsiMember> dependencies = this.getDependenciesOf(member);
        if (dependencies == null || dependencies.size() == 0) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(RefactoringBundle.message((String)"interface.member.dependency.required.by.interfaces", (Object[])new Object[]{dependencies.size()}));
        Iterator<? extends PsiMember> iterator = dependencies.iterator();
        while (iterator.hasNext()) {
            PsiClass aClass = (PsiClass)iterator.next();
            buffer.append(aClass.getName());
            if (!iterator.hasNext()) continue;
            buffer.append(", ");
        }
        return buffer.toString();
    }

    protected void addInterfaceDeps(PsiClass intf) {
        HashSet<PsiMethod> interfaceMethods = (HashSet<PsiMethod>)this.myMethodsFromInterfaces.get((Object)intf);
        if (interfaceMethods == null) {
            interfaceMethods = new HashSet<PsiMethod>();
            this.buildInterfaceMethods(interfaceMethods, intf);
            this.myMethodsFromInterfaces.put((Object)intf, interfaceMethods);
        }
        for (PsiMethod method : interfaceMethods) {
            HashSet<PsiClass> interfaces = (HashSet<PsiClass>)this.myMembersToInterfacesMap.get((Object)method);
            if (interfaces == null) {
                interfaces = new HashSet<PsiClass>();
                this.myMembersToInterfacesMap.put((Object)method, interfaces);
            }
            interfaces.add(intf);
        }
        this.myInterfaceDependencies.addAll(interfaceMethods);
    }

    private void buildInterfaceMethods(HashSet<PsiMethod> interfaceMethods, PsiClass intf) {
        PsiReferenceList extendsList;
        PsiMethod[] methods;
        for (PsiMethod method1 : methods = intf.getMethods()) {
            PsiMethod method = this.myClass.findMethodBySignature(method1, true);
            if (method == null) continue;
            interfaceMethods.add(method);
        }
        PsiReferenceList implementsList = intf.getImplementsList();
        if (implementsList != null) {
            PsiClassType[] implemented;
            for (PsiClassType aImplemented : implemented = implementsList.getReferencedTypes()) {
                PsiClass resolved = aImplemented.resolve();
                if (resolved == null) continue;
                this.buildInterfaceMethods(interfaceMethods, resolved);
            }
        }
        if ((extendsList = intf.getExtendsList()) != null) {
            PsiClassType[] extended;
            for (PsiClassType aExtended : extended = extendsList.getReferencedTypes()) {
                PsiClass ref = aExtended.resolve();
                if (ref == null) continue;
                this.buildInterfaceMethods(interfaceMethods, ref);
            }
        }
    }
}

