/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.growl.Growl;
import com.intellij.util.ArrayUtil;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;

class GrowlNotifications {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ui.GrowlNotifications");
    private static GrowlNotifications ourNotifications;
    private final Set<String> myNotifications = new TreeSet<String>();
    private Growl myGrowl;

    public GrowlNotifications() {
        this(ApplicationNamesInfo.getInstance().getFullProductName());
    }

    GrowlNotifications(String fullProductName) {
        this.myGrowl = new Growl(fullProductName);
        this.register();
    }

    private String[] getAllNotifications() {
        return ArrayUtil.toStringArray(this.myNotifications);
    }

    public static synchronized GrowlNotifications getNotifications() {
        if (ourNotifications == null) {
            ourNotifications = new GrowlNotifications();
        }
        return ourNotifications;
    }

    public void notify(Set<String> allNotifications, @NotNull String notificationName, String title, String description) {
        if (notificationName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ui/GrowlNotifications.notify must not be null");
        }
        if (!((Object)this.myNotifications).equals(allNotifications)) {
            this.myNotifications.addAll(allNotifications);
            this.register();
        }
        try {
            this.myGrowl.notifyGrowlOf(notificationName, title, description);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    private void register() {
        this.myGrowl.setAllowedNotifications(this.getAllNotifications());
        try {
            this.myGrowl.setDefaultNotifications(this.getAllNotifications());
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        this.myGrowl.register();
    }
}

