/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.NonDefaultProjectConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.FileColorManager;
import com.intellij.ui.tabs.FileColorManagerImpl;
import com.intellij.ui.tabs.FileColorsConfigurablePanel;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class FileColorsConfigurable
implements Configurable,
NonDefaultProjectConfigurable {
    private Project myProject;
    private FileColorsConfigurablePanel myPanel;

    public FileColorsConfigurable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/tabs/FileColorsConfigurable.<init> must not be null");
        }
        this.myProject = project;
    }

    @Nls
    public String getDisplayName() {
        return "File Colors";
    }

    public Icon getIcon() {
        return null;
    }

    public String getHelpTopic() {
        return "reference.settings.ide.settings.file-colors";
    }

    public JComponent createComponent() {
        if (this.myPanel == null) {
            this.myPanel = new FileColorsConfigurablePanel((FileColorManagerImpl)FileColorManager.getInstance((Project)this.myProject));
        }
        return this.myPanel;
    }

    public boolean isModified() {
        return this.myPanel != null && this.myPanel.isModified();
    }

    public void apply() throws ConfigurationException {
        if (this.myPanel != null) {
            this.myPanel.apply();
        }
    }

    public void reset() {
        if (this.myPanel != null) {
            this.myPanel.reset();
        }
    }

    public void disposeUIResources() {
        if (this.myPanel != null) {
            Disposer.dispose((Disposable)this.myPanel);
            this.myPanel = null;
        }
    }
}

