/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.unscramble;

import com.intellij.openapi.application.ApplicationAdapter;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.unscramble.AnalyzeStacktraceUtil;
import com.intellij.unscramble.UnscrambleDialog;
import java.util.regex.Pattern;

public class UnscrambleListener
extends ApplicationAdapter {
    private static final int MAX_STACKTRACE_SIZE = 102400;
    private String stacktrace = null;
    private static final Pattern STACKTRACE_LINE = Pattern.compile("[\t]*at [[a-zA-Z0-9]+\\.]+[a-zA-Z$0-9]+\\.[a-zA-Z0-9_]+\\([A-Za-z0-9_]+\\.java:[\\d]+\\)");

    public void applicationActivated(IdeFrame ideFrame) {
        String clipboard = AnalyzeStacktraceUtil.getTextInClipboard();
        if (clipboard != null && clipboard.length() < 102400 && !clipboard.equals(this.stacktrace)) {
            this.stacktrace = clipboard;
            if (UnscrambleListener.isStacktrace(this.stacktrace)) {
                UnscrambleDialog dialog = new UnscrambleDialog(ideFrame.getProject());
                dialog.createNormalizeTextAction().actionPerformed(null);
                dialog.doOKAction();
            }
        }
    }

    public void applicationDeactivated(IdeFrame ideFrame) {
        this.stacktrace = AnalyzeStacktraceUtil.getTextInClipboard();
    }

    public static boolean isStacktrace(String stacktrace) {
        int linesCount = 0;
        for (String line : stacktrace.split("\n")) {
            if ((line = line.trim()).length() == 0) continue;
            if (line.endsWith("\r")) {
                line = line.substring(0, line.length() - 1);
            }
            linesCount = STACKTRACE_LINE.matcher(line).matches() ? ++linesCount : 0;
            if (linesCount <= 2) continue;
            return true;
        }
        return false;
    }
}

