/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.actions.generate.DomTemplateRunner;
import org.jetbrains.annotations.Nullable;

public class DomTemplateRunnerImpl
extends DomTemplateRunner {
    private final Project myProject;

    public DomTemplateRunnerImpl(Project project) {
        this.myProject = project;
    }

    public <T extends DomElement> void runTemplate(T t, String mappingId, Editor editor) {
        Template template = DomTemplateRunnerImpl.getTemplate(mappingId);
        this.runTemplate(t, editor, template);
    }

    public <T extends DomElement> void runTemplate(T t, Editor editor, @Nullable Template template) {
        if (template != null) {
            DomElement copy = t.createStableCopy();
            PsiDocumentManager.getInstance((Project)this.myProject).doPostponedOperationsAndUnblockDocument(editor.getDocument());
            XmlTag tag = copy.getXmlTag();
            assert (tag != null);
            editor.getCaretModel().moveToOffset(tag.getTextRange().getStartOffset());
            copy.undefine();
            PsiDocumentManager.getInstance((Project)this.myProject).doPostponedOperationsAndUnblockDocument(editor.getDocument());
            template.setToReformat(true);
            TemplateManager.getInstance(this.myProject).startTemplate(editor, template);
        }
    }

    @Nullable
    protected static Template getTemplate(String mappingId) {
        return mappingId != null ? TemplateSettings.getInstance().getTemplateById(mappingId) : null;
    }
}

