/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.frame;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.containers.HashMap;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.impl.frame.ThreadComboBoxRenderer;
import com.intellij.xdebugger.impl.frame.XDebugViewBase;
import com.intellij.xdebugger.impl.frame.XDebuggerFramesList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;

public class XFramesView
extends XDebugViewBase {
    private final JPanel myMainPanel;
    private final XDebuggerFramesList myFramesList;
    private final JComboBox myThreadComboBox;
    private XExecutionStack mySelectedStack;
    private boolean myListenersEnabled;
    private final Map<XExecutionStack, StackFramesListBuilder> myBuilders = new HashMap();

    public XFramesView(XDebugSession session, Disposable parentDisposable) {
        super(session, parentDisposable);
        this.myMainPanel = new JPanel(new BorderLayout());
        this.myThreadComboBox = new JComboBox();
        this.myThreadComboBox.setRenderer(new ThreadComboBoxRenderer());
        this.myThreadComboBox.addItemListener(new MyItemListener());
        this.myMainPanel.add((Component)this.myThreadComboBox, "North");
        this.myFramesList = new XDebuggerFramesList();
        this.myFramesList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                XFramesView.this.processFrameSelection();
            }
        });
        this.myFramesList.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int i = XFramesView.this.myFramesList.locationToIndex(e.getPoint());
                if (i != -1 && XFramesView.this.myFramesList.isSelectedIndex(i)) {
                    XFramesView.this.processFrameSelection();
                }
            }
        });
        this.myMainPanel.add((Component)ScrollPaneFactory.createScrollPane((JComponent)this.myFramesList), "Center");
        this.rebuildView(XDebugViewBase.SessionEvent.RESUMED);
    }

    private StackFramesListBuilder getOrCreateBuilder(XExecutionStack executionStack) {
        StackFramesListBuilder builder = this.myBuilders.get(executionStack);
        if (builder == null) {
            builder = new StackFramesListBuilder(executionStack);
            this.myBuilders.put(executionStack, builder);
        }
        return builder;
    }

    @Override
    protected void rebuildView(XDebugViewBase.SessionEvent event) {
        XExecutionStack[] executionStacks;
        if (event == XDebugViewBase.SessionEvent.BEFORE_RESUME) {
            return;
        }
        if (event == XDebugViewBase.SessionEvent.FRAME_CHANGED) {
            XStackFrame currentStackFrame = this.mySession.getCurrentStackFrame();
            if (currentStackFrame != null) {
                this.myFramesList.setSelectedValue(currentStackFrame, true);
            }
            return;
        }
        this.myListenersEnabled = false;
        for (StackFramesListBuilder builder : this.myBuilders.values()) {
            builder.dispose();
        }
        this.myBuilders.clear();
        XSuspendContext suspendContext = this.mySession.getSuspendContext();
        if (suspendContext == null) {
            this.myThreadComboBox.removeAllItems();
            this.myFramesList.clear();
            return;
        }
        for (XExecutionStack executionStack : executionStacks = suspendContext.getExecutionStacks()) {
            this.myThreadComboBox.addItem(executionStack);
        }
        XExecutionStack activeExecutionStack = suspendContext.getActiveExecutionStack();
        this.myThreadComboBox.setSelectedItem(activeExecutionStack);
        this.myThreadComboBox.setVisible(executionStacks.length != 1);
        this.updateFrames(activeExecutionStack);
        this.myListenersEnabled = true;
    }

    private void updateFrames(XExecutionStack executionStack) {
        if (this.mySelectedStack == executionStack) {
            return;
        }
        if (this.mySelectedStack != null) {
            this.getOrCreateBuilder(this.mySelectedStack).stop();
        }
        this.mySelectedStack = executionStack;
        if (executionStack != null) {
            StackFramesListBuilder builder = this.getOrCreateBuilder(executionStack);
            builder.initModel(this.myFramesList.getModel());
            builder.start();
            XStackFrame topFrame = executionStack.getTopFrame();
            if (topFrame != null) {
                this.myFramesList.setSelectedValue(topFrame, true);
                this.onFrameSelected(topFrame);
            }
        }
    }

    public XDebuggerFramesList getFramesList() {
        return this.myFramesList;
    }

    private void onFrameSelected(@NotNull XStackFrame stackFrame) {
        if (stackFrame == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/frame/XFramesView.onFrameSelected must not be null");
        }
        this.mySession.setCurrentStackFrame(stackFrame);
    }

    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    private void processFrameSelection() {
        if (!this.myListenersEnabled) {
            return;
        }
        Object selected = this.myFramesList.getSelectedValue();
        if (selected instanceof XStackFrame) {
            this.onFrameSelected((XStackFrame)selected);
        }
    }

    private class StackFramesListBuilder
    implements XExecutionStack.XStackFrameContainer {
        private XExecutionStack myExecutionStack;
        private final List<XStackFrame> myStackFrames;
        private String myErrorMessage;
        private int myNextFrameIndex;
        private boolean myRunning;
        private boolean myAllFramesLoaded;

        private StackFramesListBuilder(XExecutionStack executionStack) {
            this.myExecutionStack = executionStack;
            this.myStackFrames = new ArrayList<XStackFrame>();
            this.myStackFrames.add(executionStack.getTopFrame());
            this.myNextFrameIndex = 1;
        }

        public void addStackFrames(final @NotNull List<? extends XStackFrame> stackFrames, final boolean last) {
            if (stackFrames == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/frame/XFramesView$StackFramesListBuilder.addStackFrames must not be null");
            }
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    StackFramesListBuilder.this.myStackFrames.addAll(stackFrames);
                    StackFramesListBuilder.this.addFrameListElements(stackFrames, last);
                    StackFramesListBuilder.this.myNextFrameIndex += stackFrames.size();
                    StackFramesListBuilder.this.myAllFramesLoaded = last;
                    if (last) {
                        StackFramesListBuilder.this.myRunning = false;
                    }
                }
            });
        }

        private void addFrameListElements(List<?> values, boolean last) {
            if (this.myExecutionStack != null && this.myExecutionStack == XFramesView.this.mySelectedStack) {
                DefaultListModel model = XFramesView.this.myFramesList.getModel();
                if (model.getElementAt(model.getSize() - 1) == null) {
                    model.removeElementAt(model.getSize() - 1);
                }
                for (Object value : values) {
                    model.addElement(value);
                }
                if (!last) {
                    model.addElement(null);
                }
                XFramesView.this.myFramesList.repaint();
            }
        }

        public boolean isObsolete() {
            return !this.myRunning;
        }

        public void errorOccured(final String errorMessage) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    StackFramesListBuilder.this.myErrorMessage = errorMessage;
                    StackFramesListBuilder.this.addFrameListElements(Collections.singletonList(errorMessage), true);
                    StackFramesListBuilder.this.myRunning = false;
                }
            });
        }

        public void dispose() {
            this.myRunning = false;
            this.myExecutionStack = null;
        }

        public void start() {
            if (this.myExecutionStack == null) {
                return;
            }
            this.myRunning = true;
            this.myExecutionStack.computeStackFrames(this.myNextFrameIndex, (XExecutionStack.XStackFrameContainer)this);
        }

        public void stop() {
            this.myRunning = false;
        }

        public void initModel(DefaultListModel model) {
            model.removeAllElements();
            for (XStackFrame stackFrame : this.myStackFrames) {
                model.addElement(stackFrame);
            }
            if (this.myErrorMessage != null) {
                model.addElement(this.myErrorMessage);
            } else if (!this.myAllFramesLoaded) {
                model.addElement(null);
            }
        }
    }

    private class MyItemListener
    implements ItemListener {
        private MyItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            Object item;
            if (!XFramesView.this.myListenersEnabled) {
                return;
            }
            if (e.getStateChange() == 1 && (item = e.getItem()) instanceof XExecutionStack) {
                XFramesView.this.updateFrames((XExecutionStack)item);
            }
        }
    }
}

