/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.confusing;

import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.intentions.utils.BoolUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrCondition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;

public class GroovyNegatedIfInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("Potentially confusing code constructs" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyNegatedIfInspection.getGroupDisplayName must not return null");
        }
        return "Potentially confusing code constructs";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Negated if condition expression" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyNegatedIfInspection.getDisplayName must not return null");
        }
        return "Negated if condition expression";
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "Negated if condition expression #loc";
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitIfStatement(GrIfStatement grIfStatement) {
            super.visitIfStatement(grIfStatement);
            GrCondition condition = grIfStatement.getCondition();
            if (!(condition instanceof GrExpression)) {
                return;
            }
            if (!BoolUtils.isNegation((GrExpression)condition)) {
                return;
            }
            if (grIfStatement.getElseBranch() == null || grIfStatement.getThenBranch() == null) {
                return;
            }
            this.registerError(condition);
        }
    }
}

