/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.exception;

import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrCatchClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;

public class GroovyEmptyCatchBlockInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("Error handling" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/exception/GroovyEmptyCatchBlockInspection.getGroupDisplayName must not return null");
        }
        return "Error handling";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Empty 'catch' block" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/exception/GroovyEmptyCatchBlockInspection.getDisplayName must not return null");
        }
        return "Empty 'catch' block";
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "Empty '#ref' block #loc";
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitCatchClause(GrCatchClause catchClause) {
            super.visitCatchClause(catchClause);
            GrOpenBlock body = catchClause.getBody();
            if (body == null || !Visitor.isEmpty(body)) {
                return;
            }
            this.registerError(catchClause.getFirstChild());
        }

        private static boolean isEmpty(GrOpenBlock body) {
            GrStatement[] statements = body.getStatements();
            return statements.length == 0;
        }
    }
}

