/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.closure;

import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.IntentionUtils;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.intentions.closure.ImplicitClosureCallPredicate;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

public class MakeClosureCallExplicitIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        ImplicitClosureCallPredicate implicitClosureCallPredicate = new ImplicitClosureCallPredicate();
        if (implicitClosureCallPredicate == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/intentions/closure/MakeClosureCallExplicitIntention.getElementPredicate must not return null");
        }
        return implicitClosureCallPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/intentions/closure/MakeClosureCallExplicitIntention.processIntention must not be null");
        }
        GrMethodCallExpression expression = (GrMethodCallExpression)element;
        GrExpression invokedExpression = expression.getInvokedExpression();
        GrArgumentList argList = expression.getArgumentList();
        GrClosableBlock[] closureArgs = expression.getClosureArguments();
        StringBuilder newExpression = new StringBuilder();
        newExpression.append(invokedExpression.getText());
        newExpression.append(".call");
        if (argList != null) {
            newExpression.append(argList.getText());
        }
        for (GrClosableBlock closureArg : closureArgs) {
            newExpression.append(closureArg.getText());
        }
        IntentionUtils.replaceExpression(newExpression.toString(), expression);
    }
}

