/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public abstract class GrLiteralClassType
extends PsiClassType {
    protected final GlobalSearchScope myScope;
    protected final JavaPsiFacade myFacade;

    public GrLiteralClassType(LanguageLevel languageLevel, GlobalSearchScope scope, JavaPsiFacade facade) {
        super(languageLevel);
        this.myScope = scope;
        this.myFacade = facade;
    }

    protected abstract String getJavaClassName();

    @NotNull
    public PsiClassType.ClassResolveResult resolveGenerics() {
        PsiClassType.ClassResolveResult classResolveResult = new PsiClassType.ClassResolveResult(){
            private final PsiClass myBaseClass;
            {
                this.myBaseClass = GrLiteralClassType.this.resolve();
            }

            public PsiClass getElement() {
                return this.myBaseClass;
            }

            public PsiSubstitutor getSubstitutor() {
                PsiSubstitutor result = PsiSubstitutor.EMPTY;
                if (this.myBaseClass != null) {
                    PsiType[] typeArgs = GrLiteralClassType.this.getParameters();
                    PsiTypeParameter[] typeParams = this.myBaseClass.getTypeParameters();
                    if (typeParams.length == typeArgs.length) {
                        for (int i = 0; i < typeArgs.length; ++i) {
                            result = result.put(typeParams[i], typeArgs[i]);
                        }
                    }
                }
                return result;
            }

            public boolean isPackagePrefixPackageReference() {
                return false;
            }

            public boolean isAccessible() {
                return true;
            }

            public boolean isStaticsScopeCorrect() {
                return true;
            }

            public PsiElement getCurrentFileResolveScope() {
                return null;
            }

            public boolean isValidResult() {
                return this.isStaticsScopeCorrect() && this.isAccessible();
            }
        };
        if (classResolveResult == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/GrLiteralClassType.resolveGenerics must not return null");
        }
        return classResolveResult;
    }

    public String getPresentableText() {
        return this.getClassName();
    }

    @Nullable
    public String getCanonicalText() {
        PsiClass resolved = this.resolve();
        if (resolved == null) {
            return null;
        }
        return resolved.getQualifiedName();
    }

    @NotNull
    public LanguageLevel getLanguageLevel() {
        LanguageLevel languageLevel = this.myLanguageLevel;
        if (languageLevel == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/GrLiteralClassType.getLanguageLevel must not return null");
        }
        return languageLevel;
    }

    public GlobalSearchScope getScope() {
        return this.myScope;
    }

    @Nullable
    public PsiClass resolve() {
        return this.myFacade.findClass(this.getJavaClassName(), this.getResolveScope());
    }

    @NotNull
    public PsiClassType rawType() {
        PsiClassType psiClassType = this.myFacade.getElementFactory().createTypeByFQClassName(this.getJavaClassName(), this.myScope);
        if (psiClassType == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/GrLiteralClassType.rawType must not return null");
        }
        return psiClassType;
    }

    public boolean equalsToText(@NonNls String text) {
        return text.equals(this.getJavaClassName());
    }

    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = this.myScope;
        if (globalSearchScope == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/GrLiteralClassType.getResolveScope must not return null");
        }
        return globalSearchScope;
    }

    protected static String getInternalCanonicalText(@Nullable PsiType type) {
        return type == null ? "java.lang.Object" : type.getInternalCanonicalText();
    }

    @Nullable
    private static PsiType getLeastUpperBound(@Nullable PsiType result, @Nullable PsiType other, PsiManager manager) {
        if (other == null) {
            return result;
        }
        if (result == null) {
            result = other;
        }
        if (result.isAssignableFrom(other)) {
            return result;
        }
        if (other.isAssignableFrom(result)) {
            result = other;
        }
        return TypesUtil.getLeastUpperBound(result, other, manager);
    }

    @NotNull
    protected PsiType getLeastUpperBound(PsiType[] psiTypes) {
        PsiClassType result = null;
        PsiManager manager = this.getPsiManager();
        for (PsiType other : psiTypes) {
            result = GrLiteralClassType.getLeastUpperBound((PsiType)result, other, manager);
        }
        PsiClassType psiClassType = result == null ? PsiType.getJavaLangObject((PsiManager)manager, (GlobalSearchScope)this.getResolveScope()) : result;
        if (psiClassType == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/GrLiteralClassType.getLeastUpperBound must not return null");
        }
        return psiClassType;
    }

    protected PsiManager getPsiManager() {
        return PsiManager.getInstance((Project)this.myFacade.getProject());
    }
}

