/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.stubs.impl;

import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.io.StringRef;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstant;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrFieldStub;

public class GrFieldStubImpl
extends StubBase<GrField>
implements GrFieldStub {
    public static final byte IS_PROPERTY = 1;
    public static final byte IS_ENUM_CONSTANT = 2;
    public static final byte IS_DEPRECATED_BY_DOC_TAG = 4;
    private final byte myFlags;
    private final StringRef myName;
    private final String[] myAnnotations;
    @Nullable
    private final Set<String>[] myNamedParameters;

    public GrFieldStubImpl(StubElement parent, StringRef name, String[] annotations, @NotNull Set<String>[] namedParameters, IStubElementType elemType, byte flags) {
        if (namedParameters == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/stubs/impl/GrFieldStubImpl.<init> must not be null");
        }
        super(parent, elemType);
        this.myName = name;
        this.myAnnotations = annotations;
        this.myNamedParameters = namedParameters;
        this.myFlags = flags;
    }

    @Override
    public boolean isEnumConstant() {
        return (this.myFlags & 2) != 0;
    }

    public String getName() {
        return StringRef.toString((StringRef)this.myName);
    }

    @Override
    public String[] getAnnotations() {
        return this.myAnnotations;
    }

    @Override
    @NotNull
    public Set<String>[] getNamedParameters() {
        if (this.myNamedParameters == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/stubs/impl/GrFieldStubImpl.getNamedParameters must not return null");
        }
        return this.myNamedParameters;
    }

    @Override
    public boolean isProperty() {
        return (this.myFlags & 1) != 0;
    }

    @Override
    public boolean isDeprecatedByDocTag() {
        return (this.myFlags & 4) != 0;
    }

    @Override
    public byte getFlags() {
        return this.myFlags;
    }

    public static byte buildFlags(GrField field) {
        byte f = 0;
        if (field instanceof GrEnumConstant) {
            f = (byte)(f | 2);
        }
        if (field.isProperty()) {
            f = (byte)(f | 1);
        }
        if (PsiImplUtil.isDeprecatedByDocTag((PsiDocCommentOwner)field)) {
            f = (byte)(f | 4);
        }
        return f;
    }

    public static boolean isEnumConstant(byte flags) {
        return (flags & 2) != 0;
    }
}

