/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.runner;

import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.LocatableConfigurationType;
import com.intellij.execution.Location;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyIcons;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunConfiguration;

public class GroovyScriptRunConfigurationType
implements LocatableConfigurationType {
    private final GroovyFactory myConfigurationFactory = new GroovyFactory(this);

    public String getDisplayName() {
        return "Groovy Script";
    }

    public String getConfigurationTypeDescription() {
        return "Groovy Script";
    }

    public Icon getIcon() {
        return GroovyIcons.GROOVY_ICON_16x16;
    }

    @NonNls
    @NotNull
    public String getId() {
        if ("GroovyScriptRunConfiguration" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/runner/GroovyScriptRunConfigurationType.getId must not return null");
        }
        return "GroovyScriptRunConfiguration";
    }

    public ConfigurationFactory[] getConfigurationFactories() {
        return new ConfigurationFactory[]{this.myConfigurationFactory};
    }

    public RunnerAndConfigurationSettings createConfigurationByLocation(Location location) {
        PsiElement element = location.getPsiElement();
        PsiClass clazz = GroovyScriptRunConfigurationType.getScriptClass(element);
        if (clazz == null) {
            return null;
        }
        return this.createConfiguration(clazz);
    }

    public boolean isConfigurationByLocation(RunConfiguration configuration, Location location) {
        String path = ((GroovyScriptRunConfiguration)configuration).scriptPath;
        if (path == null) {
            return false;
        }
        PsiFile file = location.getPsiElement().getContainingFile();
        if (file == null) {
            return false;
        }
        VirtualFile vfile = file.getVirtualFile();
        if (vfile == null) {
            return false;
        }
        return FileUtil.toSystemIndependentName((String)path).equals(vfile.getPath());
    }

    private RunnerAndConfigurationSettings createConfiguration(PsiClass aClass) {
        Project project = aClass.getProject();
        RunnerAndConfigurationSettingsImpl settings = RunManagerEx.getInstanceEx((Project)project).createConfiguration("", (ConfigurationFactory)this.myConfigurationFactory);
        GroovyScriptRunConfiguration configuration = (GroovyScriptRunConfiguration)settings.getConfiguration();
        PsiFile file = aClass.getContainingFile();
        PsiDirectory dir = file.getContainingDirectory();
        assert (dir != null);
        configuration.setWorkDir(dir.getVirtualFile().getPath());
        VirtualFile vFile = file.getVirtualFile();
        assert (vFile != null);
        configuration.scriptPath = vFile.getPath();
        RunConfigurationModule module = configuration.getConfigurationModule();
        String name = GroovyScriptRunConfigurationType.getConfigurationName(aClass, module);
        configuration.setName(name);
        configuration.setModule(JavaExecutionUtil.findModule((PsiClass)aClass));
        return settings;
    }

    private static String getConfigurationName(PsiClass aClass, RunConfigurationModule module) {
        String qualifiedName = aClass.getQualifiedName();
        Project project = module.getProject();
        if (qualifiedName != null) {
            PsiClass psiClass = JavaPsiFacade.getInstance((Project)project).findClass(qualifiedName.replace('$', '.'), GlobalSearchScope.projectScope((Project)project));
            if (psiClass != null) {
                return psiClass.getName();
            }
            int lastDot = qualifiedName.lastIndexOf(46);
            if (lastDot == -1 || lastDot == qualifiedName.length() - 1) {
                return qualifiedName;
            }
            return qualifiedName.substring(lastDot + 1, qualifiedName.length());
        }
        return module.getModuleName();
    }

    @Nullable
    private static PsiClass getScriptClass(PsiElement element) {
        PsiFile file = element.getContainingFile();
        if (!(file instanceof GroovyFile)) {
            return null;
        }
        return ((GroovyFile)file).getScriptClass();
    }

    public static GroovyScriptRunConfigurationType getInstance() {
        return (GroovyScriptRunConfigurationType)ConfigurationTypeUtil.findConfigurationType(GroovyScriptRunConfigurationType.class);
    }

    public static class GroovyFactory
    extends ConfigurationFactory {
        public GroovyFactory(LocatableConfigurationType type) {
            super((ConfigurationType)type);
        }

        public RunConfiguration createTemplateConfiguration(Project project) {
            return new GroovyScriptRunConfiguration("Groovy Script", project, this);
        }
    }
}

