/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SuppressByCommentOutAction
extends SuppressIntentionAction {
    private final String nonNlsCommentPattern;

    SuppressByCommentOutAction(String nonNlsCommentPattern) {
        this.nonNlsCommentPattern = nonNlsCommentPattern;
    }

    public void invoke(Project project, Editor editor, PsiElement element) throws IncorrectOperationException {
        IElementType tokenType;
        int endOffset = element.getTextRange().getEndOffset();
        int line = editor.getDocument().getLineNumber(endOffset);
        int lineEndOffset = editor.getDocument().getLineEndOffset(line);
        PsiFile file = element.getContainingFile();
        PsiComment comment = (PsiComment)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)(lineEndOffset - 1), PsiComment.class, (boolean)false);
        String prefix = "";
        if (comment != null && (tokenType = comment.getTokenType()) == JavaTokenType.END_OF_LINE_COMMENT) {
            prefix = StringUtil.trimStart((String)comment.getText(), (String)"//") + " ";
        }
        String commentText = "//" + prefix + this.nonNlsCommentPattern;
        if (prefix != "") {
            PsiComment newcom = JavaPsiFacade.getElementFactory((Project)project).createCommentFromText(commentText, element);
            comment.replace((PsiElement)newcom);
        } else {
            editor.getDocument().insertString(lineEndOffset, (CharSequence)(" " + commentText));
        }
        DaemonCodeAnalyzer.getInstance((Project)project).restart();
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @Nullable PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/i18n/SuppressByCommentOutAction.isAvailable must not be null");
        }
        return element != null && element.isValid();
    }

    @NotNull
    public String getFamilyName() {
        String string = InspectionsBundle.message((String)"suppress.inspection.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/i18n/SuppressByCommentOutAction.getFamilyName must not return null");
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = "Suppress with '" + this.nonNlsCommentPattern + "' comment";
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/i18n/SuppressByCommentOutAction.getText must not return null");
        }
        return string;
    }
}

