/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.maturity;

import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodCallUtils;
import org.jetbrains.annotations.NotNull;

public class ThrowablePrintStackTraceInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("CallToPrintStackTrace" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/maturity/ThrowablePrintStackTraceInspection.getID must not return null");
        }
        return "CallToPrintStackTrace";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("printstacktrace.call.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/maturity/ThrowablePrintStackTraceInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("printstacktrace.call.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/maturity/ThrowablePrintStackTraceInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ThrowablePrintStackTraceVisitor();
    }

    private static class ThrowablePrintStackTraceVisitor
    extends BaseInspectionVisitor {
        private ThrowablePrintStackTraceVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/maturity/ThrowablePrintStackTraceInspection$ThrowablePrintStackTraceVisitor.visitMethodCallExpression must not be null");
            }
            super.visitMethodCallExpression(expression);
            String methodName = MethodCallUtils.getMethodName(expression);
            if (!"printStackTrace".equals(methodName)) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            if (argumentList.getExpressions().length != 0) {
                return;
            }
            this.registerMethodCallError(expression, new Object[0]);
        }
    }
}

