/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.componentTree;

import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.util.Comparing;
import com.intellij.uiDesigner.componentTree.ComponentPtr;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadRootContainer;
import org.jetbrains.annotations.NotNull;

final class ComponentPtrDescriptor
extends NodeDescriptor {
    private ComponentPtr myPtr;
    private String myBinding;
    private String myTitle;

    public ComponentPtrDescriptor(@NotNull NodeDescriptor parentDescriptor, @NotNull ComponentPtr ptr) {
        if (parentDescriptor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/uiDesigner/componentTree/ComponentPtrDescriptor.<init> must not be null");
        }
        if (ptr == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/uiDesigner/componentTree/ComponentPtrDescriptor.<init> must not be null");
        }
        super(null, parentDescriptor);
        this.myPtr = ptr;
    }

    public boolean update() {
        this.myPtr.validate();
        if (!this.myPtr.isValid()) {
            this.myPtr = null;
            return true;
        }
        String oldBinding = this.myBinding;
        String oldTitle = this.myTitle;
        RadComponent component = this.myPtr.getComponent();
        this.myBinding = component instanceof RadRootContainer ? ((RadRootContainer)component).getClassToBind() : component.getBinding();
        this.myTitle = component.getComponentTitle();
        return !Comparing.equal((String)oldBinding, (String)this.myBinding) || !Comparing.equal((String)oldTitle, (String)this.myTitle);
    }

    public RadComponent getComponent() {
        return this.myPtr != null ? this.myPtr.getComponent() : null;
    }

    public Object getElement() {
        return this.myPtr;
    }
}

