/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.propertyInspector.editors;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.lw.ColorDescriptor;
import com.intellij.uiDesigner.propertyInspector.InplaceContext;
import com.intellij.uiDesigner.propertyInspector.PropertyEditor;
import com.intellij.uiDesigner.propertyInspector.renderers.ColorRenderer;
import com.intellij.uiDesigner.radComponents.RadComponent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ColorChooserUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColorEditor
extends PropertyEditor<ColorDescriptor> {
    private final String myPropertyName;
    private final TextFieldWithBrowseButton myTextField = new TextFieldWithBrowseButton();
    private ColorDescriptor myValue;
    private Project myProject;

    public ColorEditor(String propertyName) {
        this.myPropertyName = propertyName;
        this.myTextField.getTextField().setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
        this.myTextField.getTextField().setEditable(false);
        this.myTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyColorChooserDialog dialog = new MyColorChooserDialog(ColorEditor.this.myProject);
                dialog.setSelectedValue(ColorEditor.this.myValue);
                dialog.show();
                if (dialog.getExitCode() == 0) {
                    ColorEditor.this.myValue = dialog.getSelectedValue();
                    ColorEditor.this.updateTextField();
                }
            }
        });
    }

    @Override
    public ColorDescriptor getValue() throws Exception {
        return this.myValue;
    }

    @Override
    public JComponent getComponent(RadComponent component, ColorDescriptor value, InplaceContext inplaceContext) {
        this.myValue = value != null ? value : new ColorDescriptor(new Color(0));
        this.myProject = component.getModule().getProject();
        this.updateTextField();
        return this.myTextField;
    }

    private void updateTextField() {
        this.myTextField.setText(this.myValue == null ? "" : this.myValue.toString());
    }

    @Override
    public void updateUI() {
        SwingUtilities.updateComponentTreeUI((Component)this.myTextField);
    }

    private static class MyDescriptorChooserPanel
    extends AbstractColorChooserPanel {
        private final String myDisplayName;
        private final ColorDescriptor[] myColorDescriptors;
        private JList myDescriptorList;

        public MyDescriptorChooserPanel(String displayName, List<ColorDescriptor> colorDescriptorList) {
            this.myDisplayName = displayName;
            Collections.sort(colorDescriptorList, new Comparator<ColorDescriptor>(){

                @Override
                public int compare(ColorDescriptor o1, ColorDescriptor o2) {
                    return o1.toString().compareTo(o2.toString());
                }
            });
            this.myColorDescriptors = colorDescriptorList.toArray(new ColorDescriptor[colorDescriptorList.size()]);
        }

        @Override
        public void updateChooser() {
            this.myDescriptorList.setSelectedValue(this.getColorFromModel(), true);
        }

        @Override
        protected void buildChooser() {
            this.setLayout(new BorderLayout());
            this.myDescriptorList = new JList<ColorDescriptor>(this.myColorDescriptors);
            this.myDescriptorList.setSelectionMode(0);
            this.myDescriptorList.setVisibleRowCount(15);
            this.myDescriptorList.setCellRenderer(new ColorRenderer());
            this.myDescriptorList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    ColorDescriptor descriptor = (ColorDescriptor)MyDescriptorChooserPanel.this.myDescriptorList.getSelectedValue();
                    MyDescriptorChooserPanel.this.getColorSelectionModel().setSelectedColor(new ColorDescriptorWrapper(descriptor));
                }
            });
            this.add((Component)new JScrollPane(this.myDescriptorList), "Center");
        }

        @Override
        public String getDisplayName() {
            return this.myDisplayName;
        }

        @Override
        @Nullable
        public Icon getSmallDisplayIcon() {
            return null;
        }

        @Override
        @Nullable
        public Icon getLargeDisplayIcon() {
            return null;
        }
    }

    private class MyColorChooserDialog
    extends DialogWrapper {
        private JColorChooser myColorChooser;
        private MyDescriptorChooserPanel mySwingChooserPanel;
        private MyDescriptorChooserPanel mySystemChooserPanel;
        private MyDescriptorChooserPanel myAWTChooserPanel;

        public MyColorChooserDialog(Project project) {
            super(project, false);
            this.setTitle(UIDesignerBundle.message("color.chooser.title", ColorEditor.this.myPropertyName));
            this.init();
        }

        protected JComponent createCenterPanel() {
            this.myColorChooser = new JColorChooser();
            this.mySwingChooserPanel = new MyDescriptorChooserPanel(UIDesignerBundle.message("color.chooser.swing.palette", new Object[0]), this.collectSwingColorDescriptors());
            this.myColorChooser.addChooserPanel(this.mySwingChooserPanel);
            this.mySystemChooserPanel = new MyDescriptorChooserPanel(UIDesignerBundle.message("color.chooser.system.palette", new Object[0]), this.collectColorFields(SystemColor.class, true));
            this.myColorChooser.addChooserPanel(this.mySystemChooserPanel);
            this.myAWTChooserPanel = new MyDescriptorChooserPanel(UIDesignerBundle.message("color.chooser.awt.palette", new Object[0]), this.collectColorFields(Color.class, false));
            this.myColorChooser.addChooserPanel(this.myAWTChooserPanel);
            return this.myColorChooser;
        }

        private void selectTabForColor(@Nullable ColorDescriptor value) {
            String tabName;
            if (value == null || value.getSwingColor() != null) {
                tabName = this.mySwingChooserPanel.getDisplayName();
            } else if (value.getSystemColor() != null) {
                tabName = this.mySystemChooserPanel.getDisplayName();
            } else if (value.getAWTColor() != null) {
                tabName = this.myAWTChooserPanel.getDisplayName();
            } else {
                return;
            }
            ColorChooserUI ui = this.myColorChooser.getUI();
            try {
                Field field = ui.getClass().getDeclaredField("tabbedPane");
                field.setAccessible(true);
                JTabbedPane tabbedPane = (JTabbedPane)field.get(ui);
                for (int i = 0; i < tabbedPane.getTabCount(); ++i) {
                    if (!tabbedPane.getTitleAt(i).equals(tabName)) continue;
                    tabbedPane.setSelectedIndex(i);
                    break;
                }
            }
            catch (NoSuchFieldException e) {
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }

        private List<ColorDescriptor> collectSwingColorDescriptors() {
            ArrayList<ColorDescriptor> result = new ArrayList<ColorDescriptor>();
            UIDefaults defaults = UIManager.getDefaults();
            Enumeration e = defaults.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                Object value = defaults.get(key);
                if (!(key instanceof String) || !(value instanceof Color)) continue;
                result.add(ColorDescriptor.fromSwingColor((String)((String)key)));
            }
            return result;
        }

        private List<ColorDescriptor> collectColorFields(Class aClass, boolean isSystem) {
            Field[] colorFields;
            ArrayList<ColorDescriptor> result = new ArrayList<ColorDescriptor>();
            for (Field field : colorFields = aClass.getDeclaredFields()) {
                if ((field.getModifiers() & 8) == 0 || !Color.class.isAssignableFrom(field.getType()) || !Character.isLowerCase(field.getName().charAt(0))) continue;
                ColorDescriptor color = isSystem ? ColorDescriptor.fromSystemColor((String)field.getName()) : ColorDescriptor.fromAWTColor((String)field.getName());
                result.add(color);
            }
            return result;
        }

        public void setSelectedValue(@NotNull ColorDescriptor value) {
            if (value == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/uiDesigner/propertyInspector/editors/ColorEditor$MyColorChooserDialog.setSelectedValue must not be null");
            }
            this.myColorChooser.setColor(new ColorDescriptorWrapper(value));
            this.selectTabForColor(value);
        }

        public ColorDescriptor getSelectedValue() {
            Color color = this.myColorChooser.getColor();
            if (color instanceof ColorDescriptorWrapper) {
                return ((ColorDescriptorWrapper)color).getDescriptor();
            }
            return new ColorDescriptor(color);
        }
    }

    private static class ColorDescriptorWrapper
    extends Color {
        private final ColorDescriptor myDescriptor;

        public ColorDescriptorWrapper(ColorDescriptor descriptor) {
            super(descriptor.getResolvedColor() == null ? 0 : descriptor.getResolvedColor().getRGB());
            this.myDescriptor = descriptor;
        }

        public ColorDescriptor getDescriptor() {
            return this.myDescriptor;
        }
    }
}

