/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffManager;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.SimpleContent;
import com.intellij.openapi.diff.SimpleDiffRequest;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.history.SvnRepositoryContentRevision;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.ISVNPropertyHandler;
import org.tmatesoft.svn.core.wc.SVNPropertyData;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient;

abstract class AbstractShowPropertiesDiffAction
extends AnAction
implements DumbAware {
    private static final String ourPropertiesDelimiter = "\n";

    protected AbstractShowPropertiesDiffAction(String name) {
        super(name);
    }

    protected abstract DataKey<Change[]> getChangesKey();

    @Nullable
    protected abstract SVNRevision getBeforeRevisionValue(Change var1, SvnVcs var2) throws SVNException;

    @Nullable
    protected abstract SVNRevision getAfterRevisionValue(Change var1, SvnVcs var2) throws SVNException;

    public void update(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        Change[] changes = (Change[])e.getData(this.getChangesKey());
        Presentation presentation = e.getPresentation();
        presentation.setVisible(VcsDataKeys.CHANGES.getData(dataContext) != null);
        presentation.setEnabled(this.enabled(project, changes));
    }

    private boolean enabled(Project project, Change[] changes) {
        ContentRevision revision;
        boolean noChange;
        boolean bl = noChange = project == null || changes == null || changes.length != 1;
        if (noChange) {
            return false;
        }
        Change change = changes[0];
        ContentRevision contentRevision = revision = change.getBeforeRevision() != null ? change.getBeforeRevision() : change.getAfterRevision();
        if (revision == null || !(revision.getRevisionNumber() instanceof SvnRevisionNumber)) {
            return false;
        }
        return this.checkVcs(project, change);
    }

    protected boolean checkVcs(Project project, Change change) {
        VirtualFile virtualFile = ChangesUtil.getFilePath((Change)change).getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        AbstractVcs vcs = ChangesUtil.getVcsForFile((VirtualFile)virtualFile, (Project)project);
        return vcs != null && "svn".equals(vcs.getName());
    }

    public void actionPerformed(AnActionEvent e) {
        Change[] changes;
        DataContext dataContext = e.getDataContext();
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        if (!this.enabled(project, changes = (Change[])e.getData(this.getChangesKey()))) {
            return;
        }
        Change change = changes[0];
        CalculateAndShow worker = new CalculateAndShow(project, change, e.getPresentation().getText());
        ProgressManager.getInstance().run((Task)worker);
    }

    private String getDiffWindowTitle(Change change) {
        if (change.isMoved() || change.isRenamed()) {
            FilePath beforeFilePath = ChangesUtil.getBeforePath((Change)change);
            FilePath afterFilePath = ChangesUtil.getAfterPath((Change)change);
            String beforePath = beforeFilePath == null ? "" : beforeFilePath.getIOFile().getAbsolutePath();
            String afterPath = afterFilePath == null ? "" : afterFilePath.getIOFile().getAbsolutePath();
            return SvnBundle.message("action.Subversion.properties.difference.diff.for.move.title", beforePath, afterPath);
        }
        return SvnBundle.message("action.Subversion.properties.difference.diff.title", ChangesUtil.getFilePath((Change)change).getIOFile().getAbsolutePath());
    }

    private int compareRevisions(@NonNls SVNRevision revision1, @NonNls SVNRevision revision2) {
        if (revision1.equals((Object)revision2)) {
            return 0;
        }
        if (SVNRevision.WORKING.equals((Object)revision1)) {
            return 1;
        }
        if (SVNRevision.WORKING.equals((Object)revision2)) {
            return -1;
        }
        if (SVNRevision.HEAD.equals((Object)revision1)) {
            return 1;
        }
        if (SVNRevision.HEAD.equals((Object)revision2)) {
            return -1;
        }
        return revision1.getNumber() > revision2.getNumber() ? 1 : -1;
    }

    private String revisionToString(SVNRevision revision) {
        if (revision == null) {
            return "not exists";
        }
        return revision.toString();
    }

    private String getPropertyList(ContentRevision contentRevision, SVNRevision revision, SVNWCClient client) throws SVNException {
        if (contentRevision == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        final ArrayList lines = new ArrayList();
        File ioFile = contentRevision.getFile().getIOFile();
        final ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            indicator.checkCanceled();
            indicator.setText(SvnBundle.message("show.properties.diff.progress.text.revision.information", revision.toString()));
        }
        ISVNPropertyHandler propertyHandler = new ISVNPropertyHandler(){

            public void handleProperty(File path, SVNPropertyData property) throws SVNException {
                if (indicator != null) {
                    indicator.checkCanceled();
                    indicator.setText2(SvnBundle.message("show.properties.diff.progress.text2.property.information", property.getName()));
                }
                lines.add(property);
            }

            public void handleProperty(SVNURL url, SVNPropertyData property) throws SVNException {
                if (indicator != null) {
                    indicator.checkCanceled();
                    indicator.setText2(SvnBundle.message("show.properties.diff.progress.text2.property.information", property.getName()));
                }
                lines.add(property);
            }

            public void handleProperty(long revision, SVNPropertyData property) throws SVNException {
            }
        };
        if (contentRevision instanceof SvnRepositoryContentRevision) {
            SvnRepositoryContentRevision svnRevision = (SvnRepositoryContentRevision)contentRevision;
            client.doGetProperty(SVNURL.parseURIEncoded((String)svnRevision.getFullPath()), null, revision, revision, SVNDepth.EMPTY, propertyHandler);
        } else {
            client.doGetProperty(ioFile, null, revision, revision, SVNDepth.EMPTY, propertyHandler, null);
        }
        Collections.sort(lines, new Comparator<SVNPropertyData>(){

            @Override
            public int compare(SVNPropertyData o1, SVNPropertyData o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (SVNPropertyData line : lines) {
            this.addPropertyPresentation(line, sb);
        }
        return sb.toString();
    }

    private void addPropertyPresentation(SVNPropertyData property, StringBuilder sb) {
        if (sb.length() != 0) {
            sb.append(ourPropertiesDelimiter);
        }
        sb.append(property.getName()).append("=").append(property.getValue() == null ? "" : SVNPropertyValue.getPropertyAsString((SVNPropertyValue)property.getValue()));
    }

    private class CalculateAndShow
    extends Task.Backgroundable {
        private final Change myChange;
        private String myBeforeContent;
        private String myAfterContent;
        private SVNRevision myBeforeRevisionValue;
        private SVNRevision myAfterRevision;
        private SVNException myException;
        private final String myErrorTitle;

        private CalculateAndShow(Project project, Change change, String errorTitle) {
            super(project, SvnBundle.message("fetching.properties.contents.progress.title", new Object[0]), true, Task.Backgroundable.DEAF);
            this.myChange = change;
            this.myErrorTitle = errorTitle;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/svn/actions/AbstractShowPropertiesDiffAction$CalculateAndShow.run must not be null");
            }
            SvnVcs vcs = SvnVcs.getInstance(this.myProject);
            SVNWCClient client = vcs.createWCClient();
            try {
                this.myBeforeRevisionValue = AbstractShowPropertiesDiffAction.this.getBeforeRevisionValue(this.myChange, vcs);
                this.myAfterRevision = AbstractShowPropertiesDiffAction.this.getAfterRevisionValue(this.myChange, vcs);
                this.myBeforeContent = AbstractShowPropertiesDiffAction.this.getPropertyList(this.myChange.getBeforeRevision(), this.myBeforeRevisionValue, client);
                indicator.checkCanceled();
                this.myAfterContent = AbstractShowPropertiesDiffAction.this.getPropertyList(this.myChange.getAfterRevision(), this.myAfterRevision, client);
            }
            catch (SVNException exc) {
                this.myException = exc;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (CalculateAndShow.this.myException != null) {
                        Messages.showErrorDialog((String)CalculateAndShow.this.myException.getMessage(), (String)CalculateAndShow.this.myErrorTitle);
                        return;
                    }
                    if (CalculateAndShow.this.myBeforeContent != null && CalculateAndShow.this.myAfterContent != null && CalculateAndShow.this.myBeforeRevisionValue != null && CalculateAndShow.this.myAfterRevision != null) {
                        SimpleDiffRequest diffRequest = new SimpleDiffRequest(CalculateAndShow.this.myProject, AbstractShowPropertiesDiffAction.this.getDiffWindowTitle(CalculateAndShow.this.myChange));
                        if (AbstractShowPropertiesDiffAction.this.compareRevisions(CalculateAndShow.this.myBeforeRevisionValue, CalculateAndShow.this.myAfterRevision) >= 0) {
                            diffRequest.setContents((DiffContent)new SimpleContent(CalculateAndShow.this.myAfterContent), (DiffContent)new SimpleContent(CalculateAndShow.this.myBeforeContent));
                            diffRequest.setContentTitles(AbstractShowPropertiesDiffAction.this.revisionToString(CalculateAndShow.this.myAfterRevision), AbstractShowPropertiesDiffAction.this.revisionToString(CalculateAndShow.this.myBeforeRevisionValue));
                        } else {
                            diffRequest.setContents((DiffContent)new SimpleContent(CalculateAndShow.this.myBeforeContent), (DiffContent)new SimpleContent(CalculateAndShow.this.myAfterContent));
                            diffRequest.setContentTitles(AbstractShowPropertiesDiffAction.this.revisionToString(CalculateAndShow.this.myBeforeRevisionValue), AbstractShowPropertiesDiffAction.this.revisionToString(CalculateAndShow.this.myAfterRevision));
                        }
                        DiffManager.getInstance().getDiffTool().show((DiffRequest)diffRequest);
                    }
                }
            });
        }
    }
}

