/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.report;

import com.sun.star.awt.Size;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.beans.XPropertySetInfo;
import com.sun.star.graphic.XGraphicProvider;
import com.sun.star.io.IOException;
import com.sun.star.io.XInputStream;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lib.uno.adapter.ByteArrayToXInputStreamAdapter;
import com.sun.star.lib.uno.adapter.InputStreamToXInputStreamAdapter;
import com.sun.star.report.ImageService;
import com.sun.star.report.ReportExecutionException;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.InputStream;

public class SOImageService
implements ImageService {
    private final XGraphicProvider m_xGraphicProvider;

    public SOImageService(XComponentContext xComponentContext) throws ReportExecutionException, com.sun.star.uno.Exception {
        if (xComponentContext == null) {
            throw new ReportExecutionException();
        }
        XMultiComponentFactory xMultiComponentFactory = xComponentContext.getServiceManager();
        this.m_xGraphicProvider = (XGraphicProvider)UnoRuntime.queryInterface(XGraphicProvider.class, (Object)xMultiComponentFactory.createInstanceWithContext("com.sun.star.graphic.GraphicProvider", xComponentContext));
        if (this.m_xGraphicProvider == null) {
            throw new ReportExecutionException("There is no graphic-provider available.");
        }
    }

    public Dimension getImageSize(InputStream inputStream) throws ReportExecutionException {
        return this.getImageSize((XInputStream)new InputStreamToXInputStreamAdapter(inputStream));
    }

    private Dimension getImageSize(XInputStream xInputStream) throws ReportExecutionException {
        Dimension dimension = new Dimension();
        try {
            PropertyValue[] propertyValueArray = new PropertyValue[]{new PropertyValue()};
            propertyValueArray[0].Name = "InputStream";
            propertyValueArray[0].Value = xInputStream;
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)this.m_xGraphicProvider.queryGraphic(propertyValueArray));
            if (xPropertySet != null) {
                XPropertySetInfo xPropertySetInfo = xPropertySet.getPropertySetInfo();
                if (xPropertySetInfo.hasPropertyByName("Size100thMM")) {
                    Size size = (Size)xPropertySet.getPropertyValue("Size100thMM");
                    dimension.setSize(size.Width, size.Height);
                    if (dimension.height == 0 && dimension.width == 0) {
                        size = (Size)xPropertySet.getPropertyValue("SizePixel");
                        int n = Toolkit.getDefaultToolkit().getScreenResolution();
                        double d = 2540.0 / (double)n;
                        dimension.setSize((double)size.Width * d, (double)size.Height * d);
                    }
                } else if (xPropertySetInfo.hasPropertyByName("SizePixel")) {
                    Size size = (Size)xPropertySet.getPropertyValue("SizePixel");
                    int n = Toolkit.getDefaultToolkit().getScreenResolution();
                    double d = 2540 / n;
                    dimension.setSize((double)size.Width * d, (double)size.Height * d);
                }
            }
        }
        catch (Exception exception) {
            throw new ReportExecutionException("Failed to query Image-Size", exception);
        }
        return dimension;
    }

    public Dimension getImageSize(byte[] byArray) throws ReportExecutionException {
        return this.getImageSize((XInputStream)new ByteArrayToXInputStreamAdapter(byArray));
    }

    private String getMimeType(XInputStream xInputStream) throws ReportExecutionException {
        try {
            XPropertySetInfo xPropertySetInfo;
            PropertyValue[] propertyValueArray = new PropertyValue[]{new PropertyValue()};
            propertyValueArray[0].Name = "InputStream";
            propertyValueArray[0].Value = xInputStream;
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)this.m_xGraphicProvider.queryGraphic(propertyValueArray));
            if (xPropertySet != null && (xPropertySetInfo = xPropertySet.getPropertySetInfo()).hasPropertyByName("MimeType")) {
                return (String)xPropertySet.getPropertyValue("MimeType");
            }
        }
        catch (UnknownPropertyException unknownPropertyException) {
            throw new ReportExecutionException();
        }
        catch (WrappedTargetException wrappedTargetException) {
            throw new ReportExecutionException();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ReportExecutionException();
        }
        catch (IOException iOException) {
            throw new ReportExecutionException();
        }
        return null;
    }

    public String getMimeType(InputStream inputStream) throws ReportExecutionException {
        return this.getMimeType((XInputStream)new InputStreamToXInputStreamAdapter(inputStream));
    }

    public String getMimeType(byte[] byArray) throws ReportExecutionException {
        return this.getMimeType((XInputStream)new ByteArrayToXInputStreamAdapter(byArray));
    }
}

