/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.base.boot;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.boot.AbstractBoot;
import org.pentaho.reporting.libraries.base.boot.DefaultModuleInfo;
import org.pentaho.reporting.libraries.base.boot.Module;
import org.pentaho.reporting.libraries.base.boot.ModuleInfo;
import org.pentaho.reporting.libraries.base.boot.PackageSorter;
import org.pentaho.reporting.libraries.base.boot.PackageState;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.config.PropertyFileConfiguration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.PadMessage;

public final class PackageManager {
    private static final Log LOGGER = LogFactory.getLog(PackageManager.class);
    private static final int RETURN_MODULE_LOADED = 0;
    private static final int RETURN_MODULE_UNKNOWN = 1;
    private static final int RETURN_MODULE_ERROR = 2;
    private final PackageConfiguration packageConfiguration;
    private final ArrayList modules;
    private HashMap modulesByClass;
    private final ArrayList initSections;
    private AbstractBoot booter;

    public PackageManager(AbstractBoot abstractBoot) {
        if (abstractBoot == null) {
            throw new NullPointerException();
        }
        this.booter = abstractBoot;
        this.packageConfiguration = new PackageConfiguration();
        this.modules = new ArrayList();
        this.modulesByClass = new HashMap();
        this.initSections = new ArrayList();
    }

    public boolean isModuleAvailable(ModuleInfo moduleInfo) {
        if (moduleInfo == null) {
            throw new NullPointerException();
        }
        PackageState[] packageStateArray = this.modules.toArray(new PackageState[this.modules.size()]);
        for (int i = 0; i < packageStateArray.length; ++i) {
            PackageState packageState = packageStateArray[i];
            if (!packageState.getModule().getModuleClass().equals(moduleInfo.getModuleClass())) continue;
            return packageState.getState() == 2;
        }
        return false;
    }

    public boolean isModuleAvailable(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        PackageState packageState = (PackageState)this.modulesByClass.get(string);
        if (packageState == null) {
            return false;
        }
        return packageState.getState() == 2;
    }

    public void load(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        if (this.initSections.contains(string)) {
            return;
        }
        this.initSections.add(string);
        Configuration configuration = this.booter.getGlobalConfig();
        Iterator iterator = configuration.findPropertyKeys(string);
        int n = 0;
        while (iterator.hasNext()) {
            String string2;
            String string3 = (String)iterator.next();
            if (!string3.endsWith(".Module") || (string2 = configuration.getConfigProperty(string3)) == null || string2.length() <= 0) continue;
            this.addModule(string2);
            ++n;
        }
        LOGGER.debug((Object)("Loaded a total of " + n + " modules under prefix: " + string));
    }

    public synchronized void initializeModules() {
        PackageState packageState;
        int n;
        PackageSorter.sort(this.modules);
        for (n = 0; n < this.modules.size(); ++n) {
            packageState = (PackageState)this.modules.get(n);
            if (!this.isConfigurable(packageState)) {
                packageState.markError();
                continue;
            }
            if (!packageState.configure(this.booter) || !LOGGER.isDebugEnabled()) continue;
            LOGGER.debug((Object)("Conf: " + new PadMessage(packageState.getModule().getModuleClass(), 70) + " [" + packageState.getModule().getSubSystem() + ']'));
        }
        for (n = 0; n < this.modules.size(); ++n) {
            packageState = (PackageState)this.modules.get(n);
            if (!this.isInitializable(packageState)) {
                packageState.markError();
                continue;
            }
            if (!packageState.initialize(this.booter) || !LOGGER.isDebugEnabled()) continue;
            LOGGER.debug((Object)("Init: " + new PadMessage(packageState.getModule().getModuleClass(), 70) + " [" + packageState.getModule().getSubSystem() + ']'));
        }
    }

    private boolean isConfigurable(PackageState packageState) {
        ModuleInfo[] moduleInfoArray = packageState.getModule().getRequiredModules();
        for (int i = 0; i < moduleInfoArray.length; ++i) {
            ModuleInfo moduleInfo = moduleInfoArray[i];
            String string = moduleInfo.getModuleClass();
            PackageState packageState2 = (PackageState)this.modulesByClass.get(string);
            if (packageState2 == null) {
                LOGGER.warn((Object)("Required dependency '" + string + "' for module '" + packageState.getModule().getModuleClass() + " not found."));
                return false;
            }
            if (packageState2.getState() == 1) continue;
            LOGGER.warn((Object)("Required dependency '" + string + "' for module '" + packageState.getModule().getModuleClass() + " not configured."));
            return false;
        }
        return true;
    }

    private boolean isInitializable(PackageState packageState) {
        ModuleInfo[] moduleInfoArray = packageState.getModule().getRequiredModules();
        for (int i = 0; i < moduleInfoArray.length; ++i) {
            ModuleInfo moduleInfo = moduleInfoArray[i];
            String string = moduleInfo.getModuleClass();
            PackageState packageState2 = (PackageState)this.modulesByClass.get(string);
            if (packageState2 == null) {
                LOGGER.warn((Object)("Required dependency '" + string + "' for module '" + packageState.getModule().getModuleClass() + " not found."));
                return false;
            }
            if (packageState2.getState() == 2) continue;
            LOGGER.warn((Object)("Required dependency '" + string + "' for module '" + packageState.getModule().getModuleClass() + " not initializable."));
            return false;
        }
        return true;
    }

    public synchronized void addModule(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        DefaultModuleInfo defaultModuleInfo = new DefaultModuleInfo(string, null, null, null);
        ArrayList arrayList = new ArrayList();
        if (this.loadModule(defaultModuleInfo, new ArrayList(), arrayList, false)) {
            for (int i = 0; i < arrayList.size(); ++i) {
                Module module = (Module)arrayList.get(i);
                PackageState packageState = new PackageState(module);
                this.modules.add(packageState);
                this.modulesByClass.put(module.getModuleClass(), packageState);
            }
        }
    }

    private int containsModule(ArrayList arrayList, ModuleInfo moduleInfo) {
        int n;
        Object[] objectArray;
        if (arrayList != null) {
            objectArray = arrayList.toArray(new ModuleInfo[arrayList.size()]);
            for (n = 0; n < objectArray.length; ++n) {
                if (!objectArray[n].getModuleClass().equals(moduleInfo.getModuleClass())) continue;
                return 0;
            }
        }
        objectArray = this.modules.toArray(new PackageState[this.modules.size()]);
        for (n = 0; n < objectArray.length; ++n) {
            if (!((PackageState)objectArray[n]).getModule().getModuleClass().equals(moduleInfo.getModuleClass())) continue;
            if (((PackageState)objectArray[n]).getState() == -2) {
                return 2;
            }
            return 0;
        }
        return 1;
    }

    private void dropFailedModule(PackageState packageState) {
        if (!this.modules.contains(packageState)) {
            this.modules.add(packageState);
        }
    }

    private boolean loadModule(ModuleInfo moduleInfo, ArrayList arrayList, ArrayList arrayList2, boolean bl) {
        try {
            Class<?> clazz = ObjectUtilities.getClassLoader(this.getClass()).loadClass(moduleInfo.getModuleClass());
            Module module = (Module)clazz.newInstance();
            if (!this.acceptVersion(moduleInfo, module)) {
                LOGGER.warn((Object)("Module " + module.getName() + ": required version: " + moduleInfo + ", but found Version: \n" + module));
                PackageState packageState = new PackageState(module, -2);
                this.dropFailedModule(packageState);
                return false;
            }
            int n = this.containsModule(arrayList2, module);
            if (n == 2) {
                LOGGER.debug((Object)("Indicated failure for module: " + module.getModuleClass()));
                PackageState packageState = new PackageState(module, -2);
                this.dropFailedModule(packageState);
                return false;
            }
            if (n == 1) {
                if (arrayList.contains(module)) {
                    LOGGER.error((Object)("Circular module reference: This module definition is invalid: " + module.getClass()));
                    PackageState packageState = new PackageState(module, -2);
                    this.dropFailedModule(packageState);
                    return false;
                }
                arrayList.add(module);
                ModuleInfo[] moduleInfoArray = module.getRequiredModules();
                for (int i = 0; i < moduleInfoArray.length; ++i) {
                    if (this.loadModule(moduleInfoArray[i], arrayList, arrayList2, true)) continue;
                    LOGGER.debug((Object)("Indicated failure for module: " + module.getModuleClass()));
                    PackageState packageState = new PackageState(module, -2);
                    this.dropFailedModule(packageState);
                    return false;
                }
                ModuleInfo[] moduleInfoArray2 = module.getOptionalModules();
                for (int i = 0; i < moduleInfoArray2.length; ++i) {
                    if (this.loadModule(moduleInfoArray2[i], arrayList, arrayList2, true)) continue;
                    LOGGER.debug((Object)("Optional module: " + moduleInfoArray2[i].getModuleClass() + " was not loaded."));
                }
                if (this.containsModule(arrayList2, module) == 1) {
                    arrayList2.add(module);
                }
                arrayList.remove(module);
            }
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (bl) {
                LOGGER.warn((Object)("Unresolved dependency for package: " + moduleInfo.getModuleClass()));
            }
            LOGGER.debug((Object)("Module class referenced, but not in classpath: " + classNotFoundException.getMessage()));
            return false;
        }
        catch (Exception exception) {
            LOGGER.warn((Object)("Exception while loading module: " + moduleInfo), (Throwable)exception);
            return false;
        }
    }

    private boolean acceptVersion(ModuleInfo moduleInfo, Module module) {
        int n;
        if (moduleInfo.getMajorVersion() == null) {
            return true;
        }
        if (module.getMajorVersion() == null) {
            LOGGER.warn((Object)("Module " + module.getName() + " does not define a major version."));
        } else {
            n = this.acceptVersion(moduleInfo.getMajorVersion(), module.getMajorVersion());
            if (n > 0) {
                return false;
            }
            if (n < 0) {
                return true;
            }
        }
        if (moduleInfo.getMinorVersion() == null) {
            return true;
        }
        if (module.getMinorVersion() == null) {
            LOGGER.warn((Object)("Module " + module.getName() + " does not define a minor version."));
        } else {
            n = this.acceptVersion(moduleInfo.getMinorVersion(), module.getMinorVersion());
            if (n > 0) {
                return false;
            }
            if (n < 0) {
                return true;
            }
        }
        if (moduleInfo.getPatchLevel() == null) {
            return true;
        }
        if (module.getPatchLevel() == null) {
            LOGGER.debug((Object)("Module " + module.getName() + " does not define a patch level."));
        } else if (this.acceptVersion(moduleInfo.getPatchLevel(), module.getPatchLevel()) > 0) {
            LOGGER.debug((Object)("Did not accept patchlevel: " + moduleInfo.getPatchLevel() + " - " + module.getPatchLevel()));
            return false;
        }
        return true;
    }

    private int acceptVersion(String string, String string2) {
        char[] cArray;
        char[] cArray2;
        int n = Math.max(string.length(), string2.length());
        if (string.length() > string2.length()) {
            cArray2 = string.toCharArray();
            cArray = new char[n];
            int n2 = string.length() - string2.length();
            Arrays.fill(cArray, 0, n2, ' ');
            System.arraycopy(cArray, n2, string2.toCharArray(), 0, string2.length());
        } else if (string.length() < string2.length()) {
            cArray = string2.toCharArray();
            cArray2 = new char[n];
            char[] cArray3 = new char[n];
            int n3 = string2.length() - string.length();
            Arrays.fill(cArray3, 0, n3, ' ');
            System.arraycopy(cArray3, n3, string.toCharArray(), 0, string.length());
        } else {
            cArray = string2.toCharArray();
            cArray2 = string.toCharArray();
        }
        return new String(cArray2).compareTo(new String(cArray));
    }

    public PackageConfiguration getPackageConfiguration() {
        return this.packageConfiguration;
    }

    public Module[] getAllModules() {
        Module[] moduleArray = new Module[this.modules.size()];
        for (int i = 0; i < this.modules.size(); ++i) {
            PackageState packageState = (PackageState)this.modules.get(i);
            moduleArray[i] = packageState.getModule();
        }
        return moduleArray;
    }

    public Module[] getActiveModules() {
        ArrayList<Module> arrayList = new ArrayList<Module>();
        for (int i = 0; i < this.modules.size(); ++i) {
            PackageState packageState = (PackageState)this.modules.get(i);
            if (packageState.getState() != 2) continue;
            arrayList.add(packageState.getModule());
        }
        return arrayList.toArray(new Module[arrayList.size()]);
    }

    public void printUsedModules(PrintStream printStream) {
        int n;
        Module[] moduleArray = this.getAllModules();
        ArrayList<Module> arrayList = new ArrayList<Module>();
        for (n = 0; n < moduleArray.length; ++n) {
            if (!this.isModuleAvailable(moduleArray[n])) continue;
            arrayList.add(moduleArray[n]);
        }
        printStream.print("Active modules: ");
        printStream.println(arrayList.size());
        printStream.println("----------------------------------------------------------");
        for (n = 0; n < arrayList.size(); ++n) {
            Module module = (Module)arrayList.get(n);
            printStream.print(new PadMessage(module.getModuleClass(), 70));
            printStream.print(" [");
            printStream.print(module.getSubSystem());
            printStream.println("]");
            printStream.print("  Version: ");
            printStream.print(module.getMajorVersion());
            printStream.print("-");
            printStream.print(module.getMinorVersion());
            printStream.print("-");
            printStream.print(module.getPatchLevel());
            printStream.print(" Producer: ");
            printStream.println(module.getProducer());
            printStream.print("  Description: ");
            printStream.println(module.getDescription());
        }
    }

    public static class PackageConfiguration
    extends PropertyFileConfiguration {
        private static final long serialVersionUID = -2170306139946858878L;
    }
}

