/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.base.boot;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.boot.Module;
import org.pentaho.reporting.libraries.base.boot.ModuleInfo;
import org.pentaho.reporting.libraries.base.boot.PackageState;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public final class PackageSorter {
    private static final Log LOGGER = LogFactory.getLog(PackageSorter.class);

    private PackageSorter() {
    }

    public static void sort(List list) {
        int n;
        int n2;
        SortModule sortModule;
        if (list == null) {
            throw new NullPointerException();
        }
        HashMap<String, SortModule> hashMap = new HashMap<String, SortModule>();
        ArrayList<PackageState> arrayList = new ArrayList<PackageState>();
        ArrayList<SortModule> arrayList2 = new ArrayList<SortModule>();
        int n3 = list.size();
        for (int i = 0; i < n3; ++i) {
            PackageState packageState = (PackageState)list.get(i);
            if (packageState.getState() == -2) {
                arrayList.add(packageState);
                continue;
            }
            sortModule = new SortModule(packageState);
            arrayList2.add(sortModule);
            hashMap.put(packageState.getModule().getModuleClass(), sortModule);
        }
        Object[] objectArray = arrayList2.toArray(new SortModule[arrayList2.size()]);
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            sortModule = objectArray[n2];
            sortModule.setDependSubsystems(PackageSorter.collectSubsystemModules(sortModule.getState().getModule(), hashMap));
        }
        n2 = 1;
        while (n2 != 0) {
            n2 = 0;
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                int n4 = PackageSorter.searchModulePosition((SortModule)object, hashMap);
                if (n4 == ((SortModule)object).getPosition()) continue;
                ((SortModule)object).setPosition(n4);
                n2 = 1;
            }
        }
        Arrays.sort(objectArray);
        list.clear();
        for (n = 0; n < objectArray.length; ++n) {
            list.add(((SortModule)objectArray[n]).getState());
        }
        for (n = 0; n < arrayList.size(); ++n) {
            list.add(arrayList.get(n));
        }
    }

    private static int searchModulePosition(SortModule sortModule, HashMap hashMap) {
        SortModule sortModule22;
        Object object;
        int n;
        Module module = sortModule.getState().getModule();
        int n2 = 0;
        ModuleInfo[] moduleInfoArray = module.getOptionalModules();
        for (n = 0; n < moduleInfoArray.length; ++n) {
            object = moduleInfoArray[n].getModuleClass();
            sortModule22 = (SortModule)hashMap.get(object);
            if (sortModule22 == null || sortModule22.getPosition() < n2) continue;
            n2 = sortModule22.getPosition() + 1;
        }
        moduleInfoArray = module.getRequiredModules();
        for (n = 0; n < moduleInfoArray.length; ++n) {
            object = moduleInfoArray[n].getModuleClass();
            sortModule22 = (SortModule)hashMap.get(object);
            if (sortModule22 == null) {
                LOGGER.warn((Object)("Invalid state: Required dependency of '" + (String)object + "' had an error."));
                continue;
            }
            if (sortModule22.getPosition() < n2) continue;
            n2 = sortModule22.getPosition() + 1;
        }
        String string = module.getSubSystem();
        for (SortModule sortModule22 : hashMap.values()) {
            Module module2;
            if (sortModule22.getState().getModule() == module || ObjectUtilities.equal(string, (module2 = sortModule22.getState().getModule()).getSubSystem()) || !sortModule.getDependSubsystems().contains(module2.getSubSystem()) || PackageSorter.isBaseModule(module2, module) || sortModule22.getPosition() < n2) continue;
            n2 = sortModule22.getPosition() + 1;
        }
        return n2;
    }

    private static boolean isBaseModule(Module module, ModuleInfo moduleInfo) {
        int n;
        ModuleInfo[] moduleInfoArray = module.getRequiredModules();
        for (n = 0; n < moduleInfoArray.length; ++n) {
            if (!moduleInfoArray[n].getModuleClass().equals(moduleInfo.getModuleClass())) continue;
            return true;
        }
        moduleInfoArray = module.getOptionalModules();
        for (n = 0; n < moduleInfoArray.length; ++n) {
            if (!moduleInfoArray[n].getModuleClass().equals(moduleInfo.getModuleClass())) continue;
            return true;
        }
        return false;
    }

    private static ArrayList collectSubsystemModules(Module module, HashMap hashMap) {
        Object object;
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        ModuleInfo[] moduleInfoArray = module.getRequiredModules();
        for (n = 0; n < moduleInfoArray.length; ++n) {
            object = (SortModule)hashMap.get(moduleInfoArray[n].getModuleClass());
            if (object == null) {
                LOGGER.warn((Object)("A dependent module was not found in the list of known modules." + moduleInfoArray[n].getModuleClass()));
                continue;
            }
            arrayList.add(((SortModule)object).getState().getModule().getSubSystem());
        }
        moduleInfoArray = module.getOptionalModules();
        for (n = 0; n < moduleInfoArray.length; ++n) {
            object = (Module)hashMap.get(moduleInfoArray[n].getModuleClass());
            if (object == null) {
                LOGGER.warn((Object)"A dependent module was not found in the list of known modules.");
                continue;
            }
            arrayList.add(object.getSubSystem());
        }
        return arrayList;
    }

    private static class SortModule
    implements Comparable {
        private int position = -1;
        private final PackageState state;
        private ArrayList dependSubsystems;

        private SortModule(PackageState packageState) {
            this.state = packageState;
        }

        public ArrayList getDependSubsystems() {
            return this.dependSubsystems;
        }

        public void setDependSubsystems(ArrayList arrayList) {
            this.dependSubsystems = arrayList;
        }

        public int getPosition() {
            return this.position;
        }

        public void setPosition(int n) {
            this.position = n;
        }

        public PackageState getState() {
            return this.state;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(100);
            stringBuffer.append("SortModule: ");
            stringBuffer.append(this.position);
            stringBuffer.append(' ');
            stringBuffer.append(this.state.getModule().getName());
            stringBuffer.append(' ');
            stringBuffer.append(this.state.getModule().getModuleClass());
            return stringBuffer.toString();
        }

        public int compareTo(Object object) {
            SortModule sortModule = (SortModule)object;
            if (this.position > sortModule.position) {
                return 1;
            }
            if (this.position < sortModule.position) {
                return -1;
            }
            return 0;
        }
    }
}

