/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.base.util;

import java.io.IOException;
import java.io.Writer;

public final class CSVQuoter {
    private char separator;
    private char quate;
    private String doubleQuate;

    public CSVQuoter() {
        this(',', '\"');
    }

    public CSVQuoter(char c) {
        this(c, '\"');
    }

    public CSVQuoter(char c, char c2) {
        this.separator = c;
        this.quate = c2;
        this.doubleQuate = String.valueOf(c2) + c2;
    }

    public String doQuoting(String string) {
        if (this.isQuotingNeeded(string)) {
            StringBuffer stringBuffer = new StringBuffer(string.length() + 5);
            stringBuffer.append(this.quate);
            this.applyQuote(stringBuffer, string);
            stringBuffer.append(this.quate);
            return stringBuffer.toString();
        }
        return string;
    }

    public void doQuoting(String string, Writer writer) throws IOException {
        if (this.isQuotingNeeded(string)) {
            writer.write(this.quate);
            this.applyQuote(writer, string);
            writer.write(this.quate);
        } else {
            writer.write(string);
        }
    }

    public String undoQuoting(String string) {
        if (this.isQuotingNeeded(string)) {
            int n;
            StringBuffer stringBuffer = new StringBuffer(string.length());
            int n2 = string.length() - 1;
            int n3 = n = 1;
            while (n3 != -1) {
                n3 = string.indexOf(this.doubleQuate, n);
                if (n3 == -1) {
                    stringBuffer.append(string.substring(n, n2));
                    continue;
                }
                stringBuffer.append(string.substring(n, n3));
                n = n3 + 1;
            }
            return stringBuffer.toString();
        }
        return string;
    }

    private boolean isQuotingNeeded(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == this.separator) {
                return true;
            }
            if (c == '\n') {
                return true;
            }
            if (c != this.quate) continue;
            return true;
        }
        return false;
    }

    private void applyQuote(StringBuffer stringBuffer, String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == this.quate) {
                stringBuffer.append(this.doubleQuate);
                continue;
            }
            stringBuffer.append(c);
        }
    }

    private void applyQuote(Writer writer, String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == this.quate) {
                writer.write(this.doubleQuate);
                continue;
            }
            writer.write(c);
        }
    }

    public char getSeparator() {
        return this.separator;
    }

    public char getQuate() {
        return this.quate;
    }
}

