/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.base.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class IOUtils {
    private static IOUtils instance;

    private IOUtils() {
    }

    public static synchronized IOUtils getInstance() {
        if (instance == null) {
            instance = new IOUtils();
        }
        return instance;
    }

    private boolean isFileStyleProtocol(URL uRL) {
        if (uRL == null) {
            throw new NullPointerException();
        }
        String string = uRL.getProtocol();
        if ("http".equals(string)) {
            return true;
        }
        if ("https".equals(string)) {
            return true;
        }
        if ("ftp".equals(string)) {
            return true;
        }
        if ("file".equals(string)) {
            return true;
        }
        return "jar".equals(string);
    }

    private List parseName(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        while (stringTokenizer.hasMoreElements()) {
            String string2 = (String)stringTokenizer.nextElement();
            if (string2.length() == 0) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    private String formatName(List list, String string) {
        StringBuffer stringBuffer = new StringBuffer(128);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuffer.append('/');
        }
        if (string != null) {
            stringBuffer.append('?');
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private int startsWithUntil(List list, List list2) {
        int n = Math.min(list2.size(), list.size());
        for (int i = 0; i < n; ++i) {
            String string;
            String string2 = (String)list.get(i);
            if (string2.equals(string = (String)list2.get(i))) continue;
            return i;
        }
        return n;
    }

    private boolean isSameService(URL uRL, URL uRL2) {
        if (!uRL.getProtocol().equals(uRL2.getProtocol())) {
            return false;
        }
        if (!uRL.getHost().equals(uRL2.getHost())) {
            return false;
        }
        return uRL.getPort() == uRL2.getPort();
    }

    public String createRelativePath(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("targetFile must not be null.");
        }
        if (string2 == null) {
            throw new NullPointerException("baseFile must not be null.");
        }
        List list = this.parseName(string2);
        if (list.isEmpty()) {
            return string;
        }
        List list2 = this.parseName(string);
        if (list2.isEmpty()) {
            return string;
        }
        if (!(string2.length() > 0 && string2.charAt(string2.length() - 1) == '/')) {
            list.remove(list.size() - 1);
        }
        if (string2.equals(string)) {
            return (String)list2.get(list2.size() - 1);
        }
        int n = this.startsWithUntil(list2, list);
        if (n == 0) {
            return string;
        }
        if (n == list2.size()) {
            --n;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list.size() >= list2.size()) {
            int n2 = list.size() - n;
            for (int i = 0; i < n2; ++i) {
                arrayList.add("..");
            }
        }
        arrayList.addAll(list2.subList(n, list2.size()));
        return this.formatName(arrayList, null);
    }

    public String createRelativeURL(URL uRL, URL uRL2) {
        if (uRL == null) {
            throw new NullPointerException("content url must not be null.");
        }
        if (uRL2 == null) {
            throw new NullPointerException("baseURL must not be null.");
        }
        if (this.isFileStyleProtocol(uRL) && this.isSameService(uRL, uRL2)) {
            List list = this.parseName(this.getPath(uRL));
            List list2 = this.parseName(this.getPath(uRL2));
            String string = this.getQuery(uRL);
            if (!this.isPath(uRL2)) {
                list2.remove(list2.size() - 1);
            }
            if (String.valueOf(uRL).equals(String.valueOf(uRL2))) {
                return (String)list.get(list.size() - 1);
            }
            int n = this.startsWithUntil(list, list2);
            if (n == 0) {
                return uRL.toExternalForm();
            }
            if (n == list.size()) {
                --n;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            if (list2.size() >= list.size()) {
                int n2 = list2.size() - n;
                for (int i = 0; i < n2; ++i) {
                    arrayList.add("..");
                }
            }
            arrayList.addAll(list.subList(n, list.size()));
            return this.formatName(arrayList, string);
        }
        return uRL.toExternalForm();
    }

    private boolean isPath(URL uRL) {
        String string = this.getPath(uRL);
        if (string.length() > 0 && string.charAt(string.length() - 1) == '/') {
            return true;
        }
        if ("file".equals(uRL.getProtocol())) {
            File file = new File(string);
            try {
                if (file.isDirectory()) {
                    return true;
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return false;
    }

    private String getQuery(URL uRL) {
        String string = uRL.getFile();
        int n = string.indexOf(63);
        if (n == -1) {
            return null;
        }
        return string.substring(n + 1);
    }

    private String getPath(URL uRL) {
        String string = uRL.getFile();
        int n = string.indexOf(63);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public void copyStreams(InputStream inputStream, OutputStream outputStream) throws IOException {
        this.copyStreams(inputStream, outputStream, 4096);
    }

    public void copyStreams(InputStream inputStream, OutputStream outputStream, int n) throws IOException {
        byte[] byArray = new byte[n];
        int n2 = inputStream.read(byArray);
        while (n2 > -1) {
            outputStream.write(byArray, 0, n2);
            n2 = inputStream.read(byArray);
        }
    }

    public void copyWriter(Reader reader, Writer writer) throws IOException {
        this.copyWriter(reader, writer, 4096);
    }

    public void copyWriter(Reader reader, Writer writer, int n) throws IOException {
        char[] cArray = new char[n];
        int n2 = reader.read(cArray);
        while (n2 > -1) {
            writer.write(cArray, 0, n2);
            n2 = reader.read(cArray);
        }
    }

    public void readFully(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4 = n2;
        int n5 = 0;
        do {
            if ((n3 = inputStream.read(byArray, n + n5, n4)) == -1) {
                throw new IOException("End-Of-File reached");
            }
            n5 += n3;
        } while ((n4 -= n3) > 0);
    }

    public String getFileName(URL uRL) {
        String string = uRL.getFile();
        int n = string.lastIndexOf(47);
        if (n < 0) {
            return string;
        }
        return string.substring(n) + 1;
    }

    public String getFileName(String string) {
        int n = string.lastIndexOf(47);
        if (n < 0) {
            return string;
        }
        return string.substring(n) + 1;
    }

    public String stripFileExtension(String string) {
        int n = string.lastIndexOf(46);
        if (n < 1) {
            return string;
        }
        return string.substring(0, n);
    }

    public String getFileExtension(String string) {
        int n = string.lastIndexOf(46);
        if (n < 1) {
            return "";
        }
        return string.substring(n);
    }

    public boolean isSubDirectory(File file, File file2) throws IOException {
        file = file.getCanonicalFile();
        for (File file3 = file2 = file2.getCanonicalFile(); file3 != null; file3 = file3.getParentFile()) {
            if (!file.equals(file3)) continue;
            return true;
        }
        return false;
    }

    public File findFileOnClassPath(String string) {
        String string2 = System.getProperty("java.class.path");
        String string3 = System.getProperty("path.separator");
        StringTokenizer stringTokenizer = new StringTokenizer(string2, string3);
        while (stringTokenizer.hasMoreTokens()) {
            File file;
            String string4 = stringTokenizer.nextToken();
            File file2 = new File(string4);
            File file3 = file2.getAbsoluteFile();
            if (!(file3.isFile() ? (file = new File(file3.getParent(), string)).exists() : (file = new File(file2, string)).exists())) continue;
            return file;
        }
        return null;
    }

    public String getAbsolutePath(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("targetFile must not be null.");
        }
        if (string2 == null || "".equals(string2)) {
            return this.stripNavigationPaths(string);
        }
        if (string.length() > 0 && string.charAt(0) == '/') {
            return this.stripNavigationPaths(string.substring(1));
        }
        List list = this.parseName(string2);
        if (list.isEmpty()) {
            return this.stripNavigationPaths(string);
        }
        List list2 = this.parseName(string);
        if (list2.isEmpty()) {
            return this.stripNavigationPaths(string2);
        }
        if (!(string2.length() > 0 && string2.charAt(string2.length() - 1) == '/')) {
            list.remove(list.size() - 1);
            if (list.isEmpty()) {
                return this.stripNavigationPaths(string);
            }
        }
        for (int i = 0; i < list2.size(); ++i) {
            String string3 = (String)list2.get(i);
            if ("".equals(string3) || string3 == null || ".".equals(string3)) continue;
            if ("..".equals(string3)) {
                if (list.isEmpty()) continue;
                list.remove(list.size() - 1);
                continue;
            }
            list.add(string3);
        }
        String string4 = this.formatName(list, null);
        if (string.length() > 0 && string.charAt(string.length() - 1) == '/') {
            return string4 + '/';
        }
        return string4;
    }

    private String stripNavigationPaths(String string) {
        List list = this.parseName(string);
        int n = list.size();
        ArrayList<String> arrayList = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            String string2 = (String)list.get(i);
            if ("".equals(string2) || string2 == null || ".".equals(string2)) continue;
            if ("..".equals(string2)) {
                if (arrayList.isEmpty()) continue;
                arrayList.remove(arrayList.size() - 1);
                continue;
            }
            arrayList.add(string2);
        }
        String string3 = this.formatName(arrayList, null);
        if (string.length() > 0 && string.charAt(string.length() - 1) == '/') {
            return string3 + '/';
        }
        return string3;
    }
}

