/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.serializer;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.serializer.ClassComparator;
import org.pentaho.reporting.libraries.serializer.LibSerializerBoot;
import org.pentaho.reporting.libraries.serializer.SerializeMethod;

public class SerializerHelper {
    private static Log logger = LogFactory.getLog(SerializerHelper.class);
    private static SerializerHelper singleton;
    private final HashMap methods;
    private final ClassComparator comparator = new ClassComparator();

    public static synchronized SerializerHelper getInstance() {
        if (singleton == null) {
            singleton = new SerializerHelper();
            singleton.registerMethods();
        }
        return singleton;
    }

    protected static void setInstance(SerializerHelper serializerHelper) {
        singleton = serializerHelper;
    }

    protected SerializerHelper() {
        this.methods = new HashMap();
    }

    public synchronized void registerMethod(SerializeMethod serializeMethod) {
        this.methods.put(serializeMethod.getObjectClass(), serializeMethod);
    }

    protected void registerMethods() {
        Configuration configuration = LibSerializerBoot.getInstance().getGlobalConfig();
        Iterator iterator = configuration.findPropertyKeys("org.pentaho.reporting.libraries.serializer.handler.");
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = configuration.getConfigProperty(string);
            Object object = ObjectUtilities.loadAndInstantiate((String)string2, SerializerHelper.class, SerializeMethod.class);
            if (object != null) {
                SerializeMethod serializeMethod = (SerializeMethod)object;
                this.registerMethod(serializeMethod);
                continue;
            }
            logger.warn((Object)("Invalid SerializeMethod implementation: " + string2));
        }
    }

    public synchronized void unregisterMethod(SerializeMethod serializeMethod) {
        this.methods.remove(serializeMethod.getObjectClass());
    }

    protected HashMap getMethods() {
        return this.methods;
    }

    protected ClassComparator getComparator() {
        return this.comparator;
    }

    protected SerializeMethod getSerializer(Class clazz) {
        SerializeMethod serializeMethod = (SerializeMethod)this.methods.get(clazz);
        if (serializeMethod != null) {
            return serializeMethod;
        }
        return this.getSuperClassObjectDescription(clazz);
    }

    protected SerializeMethod getSuperClassObjectDescription(Class clazz) {
        SerializeMethod serializeMethod = null;
        for (Class clazz2 : this.methods.keySet()) {
            if (!clazz2.isAssignableFrom(clazz)) continue;
            SerializeMethod serializeMethod2 = (SerializeMethod)this.methods.get(clazz2);
            if (serializeMethod == null) {
                serializeMethod = serializeMethod2;
                continue;
            }
            if (!this.comparator.isComparable(serializeMethod.getObjectClass(), serializeMethod2.getObjectClass()) || this.comparator.compare(serializeMethod.getObjectClass(), serializeMethod2.getObjectClass()) >= 0) continue;
            serializeMethod = serializeMethod2;
        }
        return serializeMethod;
    }

    public synchronized void writeObject(Object object, ObjectOutputStream objectOutputStream) throws IOException {
        if (object == null) {
            objectOutputStream.writeByte(0);
            return;
        }
        if (object instanceof Serializable) {
            objectOutputStream.writeByte(1);
            objectOutputStream.writeObject(object);
            return;
        }
        SerializeMethod serializeMethod = this.getSerializer(object.getClass());
        if (serializeMethod == null) {
            throw new NotSerializableException(object.getClass().getName());
        }
        objectOutputStream.writeByte(2);
        objectOutputStream.writeObject(serializeMethod.getObjectClass());
        serializeMethod.writeObject(object, objectOutputStream);
    }

    public synchronized Object readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        byte by = objectInputStream.readByte();
        if (by == 0) {
            return null;
        }
        if (by == 1) {
            return objectInputStream.readObject();
        }
        Class clazz = (Class)objectInputStream.readObject();
        SerializeMethod serializeMethod = this.getSerializer(clazz);
        if (serializeMethod == null) {
            throw new NotSerializableException(clazz.getName());
        }
        return serializeMethod.readObject(objectInputStream);
    }
}

