/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.repository;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.repository.ContentEntity;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentItem;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.Repository;

public class RepositoryUtilities {
    private RepositoryUtilities() {
    }

    public static ContentEntity getEntity(Repository repository, String[] stringArray) throws ContentIOException {
        if (repository == null) {
            throw new NullPointerException("Repository given must not be null.");
        }
        if (stringArray == null) {
            throw new NullPointerException("Path-Name array must not be null.");
        }
        int n = stringArray.length;
        if (n == 0) {
            return repository.getRoot();
        }
        ContentLocation contentLocation = repository.getRoot();
        for (int i = 0; i < n - 1; ++i) {
            String string = stringArray[i];
            ContentEntity contentEntity = contentLocation.getEntry(string);
            if (!(contentEntity instanceof ContentLocation)) {
                throw new ContentIOException("No such item: " + string + " in " + contentLocation.getContentId());
            }
            contentLocation = (ContentLocation)contentEntity;
        }
        return contentLocation.getEntry(stringArray[n - 1]);
    }

    public static boolean isExistsEntity(Repository repository, String[] stringArray) throws ContentIOException {
        if (repository == null) {
            throw new NullPointerException("Repository given must not be null.");
        }
        if (stringArray == null) {
            throw new NullPointerException("Path-Name array must not be null.");
        }
        int n = stringArray.length;
        if (n == 0) {
            return true;
        }
        ContentLocation contentLocation = repository.getRoot();
        for (int i = 0; i < n - 1; ++i) {
            String string = stringArray[i];
            if (!contentLocation.exists(string)) {
                return false;
            }
            ContentEntity contentEntity = contentLocation.getEntry(string);
            if (!(contentEntity instanceof ContentLocation)) {
                return false;
            }
            contentLocation = (ContentLocation)contentEntity;
        }
        return contentLocation.exists(stringArray[n - 1]);
    }

    public static ContentItem createItem(Repository repository, String[] stringArray) throws ContentIOException {
        if (repository == null) {
            throw new NullPointerException("Repository given must not be null.");
        }
        if (stringArray == null) {
            throw new NullPointerException("Path-Name array must not be null.");
        }
        int n = stringArray.length;
        if (n == 0) {
            throw new IllegalArgumentException("Empty name not permitted.");
        }
        ContentLocation contentLocation = repository.getRoot();
        for (int i = 0; i < n - 1; ++i) {
            String string = stringArray[i];
            if (!contentLocation.exists(string)) {
                contentLocation = contentLocation.createLocation(string);
                continue;
            }
            ContentEntity contentEntity = contentLocation.getEntry(string);
            if (!(contentEntity instanceof ContentLocation)) {
                throw new ContentIOException("No such item.");
            }
            contentLocation = (ContentLocation)contentEntity;
        }
        return contentLocation.createItem(stringArray[n - 1]);
    }

    public static ContentLocation createLocation(Repository repository, String[] stringArray) throws ContentIOException {
        if (repository == null) {
            throw new NullPointerException("Repository given must not be null.");
        }
        if (stringArray == null) {
            throw new NullPointerException("Path-Name array must not be null.");
        }
        int n = stringArray.length;
        if (n == 0) {
            throw new IllegalArgumentException("Empty name not permitted.");
        }
        ContentLocation contentLocation = repository.getRoot();
        for (int i = 0; i < n - 1; ++i) {
            String string = stringArray[i];
            if (!contentLocation.exists(string)) {
                contentLocation = contentLocation.createLocation(string);
                continue;
            }
            ContentEntity contentEntity = contentLocation.getEntry(string);
            if (!(contentEntity instanceof ContentLocation)) {
                throw new ContentIOException("No such item.");
            }
            contentLocation = (ContentLocation)contentEntity;
        }
        return contentLocation.createLocation(stringArray[n - 1]);
    }

    public static String[] splitPath(String string, String string2) {
        String[] stringArray;
        if (string == null) {
            throw new NullPointerException("Path-Name must not be null.");
        }
        if (string2 == null) {
            throw new NullPointerException("Separator must not be null.");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2, false);
        int n = stringTokenizer.countTokens();
        String[] stringArray2 = new String[n];
        int n2 = 0;
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray2[n2] = stringArray = stringTokenizer.nextToken();
            if (!"".equals(stringArray)) {
                ++n2;
                continue;
            }
            bl = true;
        }
        if (!bl) {
            return stringArray2;
        }
        stringArray = new String[n2];
        System.arraycopy(stringArray2, 0, stringArray, 0, n2);
        return stringArray;
    }

    public static String[] split(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("Path-Name must not be null.");
        }
        if (string2 == null) {
            throw new NullPointerException("Separator must not be null.");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2, false);
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string3;
            stringArray[n2] = string3 = stringTokenizer.nextToken();
            ++n2;
        }
        return stringArray;
    }

    public static String[] buildNameArray(ContentEntity contentEntity) {
        if (contentEntity == null) {
            throw new NullPointerException("Entity given must not be null.");
        }
        ArrayList<String> arrayList = new ArrayList<String>(20);
        while (contentEntity != null) {
            ContentLocation contentLocation = contentEntity.getParent();
            if (contentLocation != null) {
                arrayList.add(0, contentEntity.getName());
            }
            contentEntity = contentLocation;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String buildName(ContentEntity object, String string) {
        int n;
        Object object2;
        if (object == null) {
            throw new NullPointerException("ContentEntity must not be null.");
        }
        if (string == null) {
            throw new NullPointerException("Separator must not be null.");
        }
        int n2 = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        while (object != null) {
            object2 = object.getParent();
            if (object2 != null) {
                String string2 = object.getName();
                if (string2.length() == 0) {
                    throw new IllegalStateException("ContentLocation with an empty name");
                }
                if (RepositoryUtilities.isInvalidPathName(string2)) {
                    throw new IllegalStateException("ContentLocation with an illegal name: " + string2);
                }
                arrayList.add(string2);
                ++n2;
                n2 += string2.length();
            }
            object = object2;
        }
        object2 = new StringBuffer(n2);
        for (int i = n = arrayList.size() - 1; i >= 0; --i) {
            String string3 = (String)arrayList.get(i);
            if (i != n) {
                ((StringBuffer)object2).append(string);
            }
            ((StringBuffer)object2).append(string3);
        }
        return ((StringBuffer)object2).toString();
    }

    public static boolean isInvalidPathName(String string) {
        if (string == null) {
            throw new NullPointerException("Name must not be null.");
        }
        boolean bl = true;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (bl && c != '.') {
                bl = false;
            }
            if (c != '\\' && c != '/') continue;
            return true;
        }
        return bl;
    }

    public static void writeAsZip(OutputStream outputStream, Repository repository) throws IOException, ContentIOException {
        ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
        RepositoryUtilities.writeToZipStream(zipOutputStream, repository);
        zipOutputStream.finish();
        zipOutputStream.flush();
    }

    public static void writeToZipStream(ZipOutputStream zipOutputStream, Repository repository) throws IOException, ContentIOException {
        RepositoryUtilities.writeLocation(repository.getRoot(), zipOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeLocation(ContentLocation contentLocation, ZipOutputStream zipOutputStream) throws IOException, ContentIOException {
        ContentEntity[] contentEntityArray = contentLocation.listContents();
        for (int i = 0; i < contentEntityArray.length; ++i) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            ZipEntry zipEntry;
            ContentEntity contentEntity;
            ContentEntity contentEntity2 = contentEntityArray[i];
            String string = RepositoryUtilities.buildName(contentEntity2, "/");
            if (contentEntity2 instanceof ContentLocation) {
                contentEntity = (ContentLocation)contentEntity2;
                zipEntry = new ZipEntry(string + '/');
                object4 = contentEntity2.getAttribute("org.jfree.repository.zip", "comment");
                if (object4 != null) {
                    zipEntry.setComment(String.valueOf(object4));
                }
                if ((object3 = contentEntity2.getAttribute("org.jfree.repository", "version")) instanceof Date) {
                    object2 = (Date)object3;
                    zipEntry.setTime(((Date)object2).getTime());
                }
                zipOutputStream.putNextEntry(zipEntry);
                RepositoryUtilities.writeLocation((ContentLocation)contentEntity, zipOutputStream);
                continue;
            }
            if (!(contentEntity2 instanceof ContentItem)) continue;
            contentEntity = (ContentItem)contentEntity2;
            zipEntry = new ZipEntry(string);
            object4 = contentEntity2.getAttribute("org.jfree.repository.zip", "comment");
            if (object4 != null) {
                zipEntry.setComment(String.valueOf(object4));
            }
            if ((object3 = contentEntity2.getAttribute("org.jfree.repository", "version")) instanceof Date) {
                object2 = (Date)object3;
                zipEntry.setTime(((Date)object2).getTime());
            }
            object2 = contentEntity2.getAttribute("org.jfree.repository.zip", "crc32");
            Object object5 = contentEntity2.getAttribute("org.jfree.repository", "size");
            if (object2 instanceof Long && object5 instanceof Long) {
                object = (Long)object2;
                Long l = (Long)object5;
                zipEntry.setSize(l);
                zipEntry.setCrc((Long)object);
                int n = RepositoryUtilities.getZipMethod((ContentItem)contentEntity);
                int n2 = RepositoryUtilities.getZipLevel((ContentItem)contentEntity);
                zipOutputStream.setMethod(n);
                zipOutputStream.setLevel(n2);
            }
            zipOutputStream.putNextEntry(zipEntry);
            object = contentEntity.getInputStream();
            try {
                IOUtils.getInstance().copyStreams((InputStream)object, (OutputStream)zipOutputStream);
            }
            finally {
                ((InputStream)object).close();
            }
            zipOutputStream.closeEntry();
        }
    }

    public static int getZipLevel(ContentItem contentItem) {
        Object object = contentItem.getAttribute("org.jfree.repository.zip", "compression");
        if (!(object instanceof Number)) {
            return -1;
        }
        Number number = (Number)object;
        int n = number.intValue();
        if (n < 0 || n > 9) {
            return -1;
        }
        return n;
    }

    public static int getZipMethod(ContentItem contentItem) {
        Object object = contentItem.getAttribute("org.jfree.repository.zip", "method");
        if (!(object instanceof Number)) {
            return 8;
        }
        Number number = (Number)object;
        int n = number.intValue();
        if (n != 0) {
            return 8;
        }
        return 0;
    }
}

