/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.repository.zipwriter;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import org.pentaho.reporting.libraries.repository.ContentCreationException;
import org.pentaho.reporting.libraries.repository.ContentEntity;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentItem;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.Repository;
import org.pentaho.reporting.libraries.repository.RepositoryUtilities;
import org.pentaho.reporting.libraries.repository.zipwriter.ZipContentItem;
import org.pentaho.reporting.libraries.repository.zipwriter.ZipRepository;

public class ZipContentLocation
implements ContentLocation {
    private HashMap entries;
    private String name;
    private String contentId;
    private ContentLocation parent;
    private ZipRepository repository;
    private String comment;
    private long time;

    public ZipContentLocation(ZipRepository zipRepository, ContentLocation contentLocation, String string) {
        if (zipRepository == null) {
            throw new NullPointerException();
        }
        if (string == null) {
            throw new NullPointerException();
        }
        this.repository = zipRepository;
        this.parent = contentLocation;
        this.name = string;
        this.entries = new HashMap();
        this.contentId = RepositoryUtilities.buildName(this, "/") + '/';
    }

    public ContentEntity[] listContents() throws ContentIOException {
        return this.entries.values().toArray(new ContentEntity[this.entries.size()]);
    }

    public ContentEntity getEntry(String string) throws ContentIOException {
        ContentEntity contentEntity = (ContentEntity)this.entries.get(string);
        if (contentEntity == null) {
            throw new ContentIOException("Not found:" + string);
        }
        return contentEntity;
    }

    public ContentItem createItem(String string) throws ContentCreationException {
        if (this.entries.containsKey(string)) {
            throw new ContentCreationException("Entry already exists");
        }
        if (RepositoryUtilities.isInvalidPathName(string)) {
            throw new ContentCreationException("Entry-Name is not valid");
        }
        ZipContentItem zipContentItem = new ZipContentItem(string, this.repository, this);
        this.entries.put(string, zipContentItem);
        return zipContentItem;
    }

    public ContentLocation createLocation(String string) throws ContentCreationException {
        if (this.entries.containsKey(string)) {
            throw new ContentCreationException("Entry already exists");
        }
        if (RepositoryUtilities.isInvalidPathName(string)) {
            throw new ContentCreationException("Entry-Name is not valid");
        }
        ZipContentLocation zipContentLocation = new ZipContentLocation(this.repository, this, string);
        this.entries.put(string, zipContentLocation);
        if (!"/".equals(this.contentId)) {
            try {
                ZipEntry zipEntry = new ZipEntry(this.contentId + string + '/');
                this.repository.writeDirectory(zipEntry);
            }
            catch (IOException iOException) {
                throw new ContentCreationException("Failed to create directory.", iOException);
            }
        }
        return zipContentLocation;
    }

    public boolean exists(String string) {
        return this.entries.containsKey(string);
    }

    public String getName() {
        return this.name;
    }

    public Object getContentId() {
        return this.contentId;
    }

    public Object getAttribute(String string, String string2) {
        if ("org.jfree.repository".equals(string)) {
            if ("version".equals(string2)) {
                return new Date(this.time);
            }
        } else if ("org.jfree.repository.zip".equals(string) && "comment".equals(string2)) {
            return this.comment;
        }
        return null;
    }

    public boolean setAttribute(String string, String string2, Object object) {
        if ("org.jfree.repository".equals(string)) {
            if ("version".equals(string2)) {
                if (object instanceof Date) {
                    Date date = (Date)object;
                    this.time = date.getTime();
                    return true;
                }
                if (object instanceof Number) {
                    Number number = (Number)object;
                    this.time = number.longValue();
                    return true;
                }
            }
        } else if ("org.jfree.repository.zip".equals(string) && "comment".equals(string2)) {
            if (object != null) {
                this.comment = String.valueOf(object);
                return true;
            }
            this.comment = null;
            return true;
        }
        return false;
    }

    public ContentLocation getParent() {
        return this.parent;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public boolean delete() {
        return false;
    }
}

