/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.repository.zipwriter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.DefaultMimeRegistry;
import org.pentaho.reporting.libraries.repository.MimeRegistry;
import org.pentaho.reporting.libraries.repository.Repository;
import org.pentaho.reporting.libraries.repository.zipwriter.ZipContentLocation;

public class ZipRepository
implements Repository {
    private ZipOutputStream zipOutputStream;
    private MimeRegistry mimeRegistry;
    private ZipContentLocation root;

    public ZipRepository(OutputStream outputStream, int n, MimeRegistry mimeRegistry) {
        if (outputStream == null) {
            throw new NullPointerException();
        }
        if (mimeRegistry == null) {
            throw new NullPointerException();
        }
        this.mimeRegistry = mimeRegistry;
        this.zipOutputStream = new ZipOutputStream(outputStream);
        this.zipOutputStream.setLevel(n);
        this.root = new ZipContentLocation(this, null, "");
    }

    public ZipRepository(OutputStream outputStream, int n) {
        this(outputStream, n, new DefaultMimeRegistry());
    }

    public ZipRepository(OutputStream outputStream) {
        this(outputStream, -1, new DefaultMimeRegistry());
    }

    public ContentLocation getRoot() throws ContentIOException {
        return this.root;
    }

    public MimeRegistry getMimeRegistry() {
        return this.mimeRegistry;
    }

    public void close() throws IOException {
        this.zipOutputStream.finish();
        this.zipOutputStream.flush();
    }

    public void writeDirectory(ZipEntry zipEntry) throws IOException {
        this.zipOutputStream.putNextEntry(zipEntry);
    }

    public void writeContent(ZipEntry zipEntry, InputStream inputStream, int n, int n2) throws IOException {
        this.zipOutputStream.setMethod(n);
        this.zipOutputStream.setLevel(n2);
        this.zipOutputStream.putNextEntry(zipEntry);
        IOUtils.getInstance().copyStreams(inputStream, (OutputStream)this.zipOutputStream);
        this.zipOutputStream.closeEntry();
    }
}

