/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.afm;

import java.io.IOException;
import org.pentaho.reporting.libraries.fonts.afm.AfmParseUtilities;

public class AfmDirectionSection {
    private static final String START_LINE = "StartDirection ";
    private static final String UNDERLINE_POSITION = "UnderlinePosition ";
    private static final String UNDERLINE_THICKNESS = "UnderlineThickness ";
    private static final String ITALIC_ANGLE = "ItalicAngle ";
    private static final String CHARWIDTH = "CharWidth ";
    private static final String IS_FIXED_PITCH = "IsFixedPitch ";
    private double underlinePosition;
    private double underlineThickness;
    private double italicAngle;
    private double[] charWidth;
    private boolean fixedPitch;

    public void add(String string) throws IOException {
        if (string.startsWith(UNDERLINE_POSITION)) {
            this.underlinePosition = AfmParseUtilities.parseDouble(UNDERLINE_POSITION, string);
        } else if (string.startsWith(UNDERLINE_THICKNESS)) {
            this.underlineThickness = AfmParseUtilities.parseDouble(UNDERLINE_THICKNESS, string);
        } else if (string.startsWith(ITALIC_ANGLE)) {
            this.italicAngle = AfmParseUtilities.parseDouble(ITALIC_ANGLE, string);
        } else if (string.startsWith(CHARWIDTH)) {
            this.charWidth = AfmParseUtilities.parseDoubleArray(string, 2);
        } else if (string.startsWith(IS_FIXED_PITCH)) {
            String string2 = string.substring(IS_FIXED_PITCH.length());
            this.fixedPitch = "true".equalsIgnoreCase(string2);
        }
    }

    public double getUnderlinePosition() {
        return this.underlinePosition;
    }

    public double getUnderlineThickness() {
        return this.underlineThickness;
    }

    public double getItalicAngle() {
        return this.italicAngle;
    }

    public double[] getCharWidth() {
        return this.charWidth;
    }

    public boolean isFixedPitch() {
        return this.fixedPitch;
    }
}

