/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.encoding;

import org.pentaho.reporting.libraries.fonts.encoding.CodePointBuffer;

public class CodePointStream {
    private CodePointBuffer buffer;
    private int[] data;
    private int cursor;
    private int lastWritePos;
    private int increment;

    public CodePointStream(CodePointBuffer codePointBuffer, int n) {
        if (codePointBuffer == null) {
            throw new NullPointerException();
        }
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        this.buffer = codePointBuffer;
        this.data = codePointBuffer.getData();
        this.cursor = codePointBuffer.getCursor();
        this.lastWritePos = this.data.length - 1;
        this.increment = n;
    }

    public void put(int n) {
        if (this.cursor >= this.lastWritePos) {
            this.buffer.ensureSize(this.cursor + this.increment);
            this.data = this.buffer.getData();
            this.lastWritePos = this.data.length - 1;
        }
        this.data[this.cursor] = n;
        ++this.cursor;
    }

    public void put(int[] nArray) {
        if (this.cursor >= this.lastWritePos) {
            this.buffer.ensureSize(this.cursor + Math.max(this.increment, nArray.length));
            this.data = this.buffer.getData();
            this.lastWritePos = this.data.length - 1;
        }
        System.arraycopy(nArray, 0, this.data, this.cursor, nArray.length);
        this.cursor += nArray.length;
    }

    public void close() {
        this.buffer.setCursor(this.cursor);
    }
}

