/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.io;

import java.io.File;
import java.io.IOException;
import org.pentaho.reporting.libraries.fonts.io.FontDataInputSource;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class ResourceFontDataInputSource
implements FontDataInputSource {
    private transient ResourceData rawData;
    private ResourceManager loader;
    private ResourceKey source;

    public ResourceFontDataInputSource(ResourceManager resourceManager, ResourceKey resourceKey) {
        if (resourceManager == null) {
            throw new NullPointerException();
        }
        if (resourceKey == null) {
            throw new NullPointerException();
        }
        this.loader = resourceManager;
        this.source = resourceKey;
    }

    public long getLength() {
        return this.rawData.getLength();
    }

    public void readFullyAt(long l, byte[] byArray, int n) throws IOException {
        if (this.rawData == null) {
            try {
                this.rawData = this.loader.load(this.source);
            }
            catch (ResourceLoadingException resourceLoadingException) {
                throw new IOException("Failed to load the raw data.");
            }
        }
        int n2 = (int)(l & Integer.MAX_VALUE);
        try {
            this.rawData.getResource(this.loader, byArray, (long)n2, n);
        }
        catch (ResourceLoadingException resourceLoadingException) {
            throw new IOException("Unable to load data: " + resourceLoadingException.getMessage());
        }
    }

    public int readAt(long l) throws IOException {
        if (this.rawData == null) {
            try {
                this.rawData = this.loader.load(this.source);
            }
            catch (ResourceLoadingException resourceLoadingException) {
                throw new IOException("Failed to load the raw data.");
            }
        }
        int n = (int)(l & Integer.MAX_VALUE);
        byte[] byArray = new byte[1];
        long l2 = this.rawData.getLength();
        if (l2 > -1L && (long)n >= l2) {
            return -1;
        }
        try {
            this.rawData.getResource(this.loader, byArray, (long)n, 1);
            return byArray[0];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return -1;
        }
        catch (ResourceLoadingException resourceLoadingException) {
            throw new IOException("Failed to read stream.");
        }
    }

    public void dispose() {
        this.rawData = null;
    }

    public String getFileName() {
        Object object = this.source.getIdentifier();
        if (object instanceof File) {
            File file = (File)object;
            return file.getPath();
        }
        return null;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ResourceFontDataInputSource resourceFontDataInputSource = (ResourceFontDataInputSource)object;
        if (!this.loader.equals(resourceFontDataInputSource.loader)) {
            return false;
        }
        return this.source.equals((Object)resourceFontDataInputSource.source);
    }

    public int hashCode() {
        int n = this.loader.hashCode();
        n = 29 * n + this.source.hashCode();
        return n;
    }
}

