/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.registry;

import java.util.HashSet;
import org.pentaho.reporting.libraries.fonts.registry.FontFamily;
import org.pentaho.reporting.libraries.fonts.registry.FontRecord;

public class DefaultFontFamily
implements FontFamily {
    private HashSet allNames;
    private String familyName;
    private FontRecord[] fontRecords;

    public DefaultFontFamily(String string) {
        if (string == null) {
            throw new NullPointerException("A FamilyName must be given");
        }
        this.familyName = string;
        this.allNames = new HashSet();
        this.allNames.add(string);
        this.fontRecords = new FontRecord[4];
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public void addName(String string) {
        if (string == null) {
            throw new NullPointerException("Name must not be null");
        }
        this.allNames.add(string);
    }

    public String[] getAllNames() {
        return this.allNames.toArray(new String[this.allNames.size()]);
    }

    public FontRecord getFontRecord(boolean bl, boolean bl2) {
        FontRecord fontRecord;
        if (bl && bl2 && (fontRecord = this.fontRecords[3]) != null) {
            return fontRecord;
        }
        if (bl2 && (fontRecord = this.fontRecords[2]) != null) {
            return fontRecord;
        }
        if (bl && (fontRecord = this.fontRecords[1]) != null) {
            return fontRecord;
        }
        fontRecord = this.fontRecords[0];
        if (fontRecord != null) {
            return fontRecord;
        }
        for (FontRecord fontRecord2 : this.fontRecords) {
            if (fontRecord2 == null) continue;
            return fontRecord2;
        }
        return null;
    }

    public void addFontRecord(FontRecord fontRecord) {
        boolean bl = fontRecord.isBold();
        boolean bl2 = fontRecord.isItalic();
        int n = bl && bl2 ? 3 : (bl2 ? 2 : (bl ? 1 : 0));
        FontRecord fontRecord2 = this.fontRecords[n];
        if (fontRecord2 == null) {
            this.fontRecords[n] = fontRecord;
        } else {
            if (fontRecord.isOblique() && !fontRecord2.isOblique()) {
                return;
            }
            this.fontRecords[n] = fontRecord;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DefaultFontFamily defaultFontFamily = (DefaultFontFamily)object;
        return this.familyName.equals(defaultFontFamily.familyName);
    }

    public int hashCode() {
        return this.familyName.hashCode();
    }
}

