/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.registry;

import java.io.Serializable;
import org.pentaho.reporting.libraries.fonts.registry.FontIdentifier;

public class FontKey
implements Serializable,
Cloneable {
    private FontIdentifier identifier;
    private boolean aliased;
    private boolean fractional;
    private double fontSize;
    private volatile int hashKey;
    private volatile boolean hashValid;

    public FontKey(FontIdentifier fontIdentifier, boolean bl, boolean bl2, double d) {
        if (fontIdentifier == null) {
            throw new NullPointerException();
        }
        this.identifier = fontIdentifier;
        this.aliased = bl;
        this.fractional = bl2;
        this.fontSize = d;
    }

    public FontKey(FontKey fontKey) {
        this.identifier = fontKey.identifier;
        this.aliased = fontKey.aliased;
        this.fractional = fontKey.fractional;
        this.fontSize = fontKey.fontSize;
        this.hashKey = fontKey.hashKey;
    }

    public FontKey() {
    }

    public FontIdentifier getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(FontIdentifier fontIdentifier) {
        this.identifier = fontIdentifier;
        this.hashValid = false;
    }

    public boolean isAliased() {
        return this.aliased;
    }

    public void setAliased(boolean bl) {
        this.aliased = bl;
        this.hashValid = false;
    }

    public boolean isFractional() {
        return this.fractional;
    }

    public void setFractional(boolean bl) {
        this.fractional = bl;
        this.hashValid = false;
    }

    public double getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(double d) {
        this.fontSize = d;
        this.hashValid = false;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        FontKey fontKey = (FontKey)object;
        if (this.aliased != fontKey.aliased) {
            return false;
        }
        if (fontKey.fontSize != this.fontSize) {
            return false;
        }
        if (this.fractional != fontKey.fractional) {
            return false;
        }
        return ((Object)this.identifier).equals(fontKey.identifier);
    }

    public int hashCode() {
        if (!this.hashValid) {
            int n = ((Object)this.identifier).hashCode();
            n = 29 * n + (this.aliased ? 1 : 0);
            n = 29 * n + (this.fractional ? 1 : 0);
            long l = this.fontSize == 0.0 ? 0L : Double.doubleToLongBits(this.fontSize);
            this.hashKey = n = 29 * n + (int)(l ^ l >>> 32);
            this.hashValid = true;
        }
        return this.hashKey;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException();
        }
    }
}

