/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.truetype;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.pentaho.reporting.libraries.fonts.ByteAccessUtilities;
import org.pentaho.reporting.libraries.fonts.truetype.TrueTypeFont;

public class TrueTypeCollection {
    public static final long MAGIC_NUMBER = 1953784678L;
    private File filename;
    private long numFonts;
    private long[] offsets;
    private TrueTypeFont[] fonts;

    public TrueTypeCollection(File file) throws IOException {
        this.filename = file;
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        byte[] byArray = new byte[12];
        randomAccessFile.readFully(byArray);
        if (ByteAccessUtilities.readULong(byArray, 0) != 1953784678L) {
            randomAccessFile.close();
            throw new IOException();
        }
        this.numFonts = ByteAccessUtilities.readLong(byArray, 8);
        byte[] byArray2 = new byte[(int)(4L * this.numFonts)];
        randomAccessFile.readFully(byArray2);
        int n = (int)this.numFonts;
        this.offsets = new long[n];
        this.fonts = new TrueTypeFont[n];
        for (int i = 0; i < n; ++i) {
            this.offsets[i] = ByteAccessUtilities.readULong(byArray2, i * 4);
        }
    }

    public File getFilename() {
        return this.filename;
    }

    public long getNumFonts() {
        return this.numFonts;
    }

    public TrueTypeFont getFont(int n) throws IOException {
        TrueTypeFont trueTypeFont;
        TrueTypeFont trueTypeFont2 = this.fonts[n];
        if (trueTypeFont2 != null) {
            return trueTypeFont2;
        }
        this.fonts[n] = trueTypeFont = new TrueTypeFont(this.filename, this.offsets[n], n);
        return trueTypeFont;
    }
}

