/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.truetype.mappings;

import org.pentaho.reporting.libraries.fonts.truetype.mappings.CustomPlatformIdentifier;
import org.pentaho.reporting.libraries.fonts.truetype.mappings.IsoPlatformIdentifier;
import org.pentaho.reporting.libraries.fonts.truetype.mappings.MacintoshPlatformIdentifier;
import org.pentaho.reporting.libraries.fonts.truetype.mappings.MicrosoftPlatformIdentifier;
import org.pentaho.reporting.libraries.fonts.truetype.mappings.UnicodePlatformIdentifier;

public abstract class PlatformIdentifier {
    public static final PlatformIdentifier UNICODE = new UnicodePlatformIdentifier();
    public static final PlatformIdentifier MACINTOSH = new MacintoshPlatformIdentifier();
    public static final PlatformIdentifier ISO = new IsoPlatformIdentifier();
    public static final PlatformIdentifier MICROSOFT = new MicrosoftPlatformIdentifier();
    private final int type;

    protected PlatformIdentifier(int n) {
        this.type = n;
    }

    public int getType() {
        return this.type;
    }

    public String toString() {
        switch (this.type) {
            case 0: {
                return "Unicode";
            }
            case 1: {
                return "Macintosh";
            }
            case 2: {
                return "ISO (deprecated)";
            }
            case 3: {
                return "Microsoft";
            }
        }
        return "Custom";
    }

    public static PlatformIdentifier getIdentifier(int n) {
        switch (n) {
            case 0: {
                return UNICODE;
            }
            case 1: {
                return MACINTOSH;
            }
            case 2: {
                return ISO;
            }
            case 3: {
                return MICROSOFT;
            }
        }
        return new CustomPlatformIdentifier(n);
    }

    public abstract String getEncoding(int var1, int var2);
}

