/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxc.pexcel.records.formula;

import java.util.ListIterator;
import java.util.Stack;
import java.util.Vector;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.formula.Token;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.formula.TokenFactory;
import org.openoffice.xmerge.util.Debug;

public class FormulaCompiler {
    private boolean isPercent(Token token) {
        return token.getTokenID() == 20;
    }

    private boolean isOpenBrace(Token token) {
        return token.getTokenID() == 21;
    }

    private boolean isCloseBrace(Token token) {
        return token.getValue().compareTo(")") == 0;
    }

    private boolean isParamDelimiter(Token token) {
        return token.getTokenID() == 4097;
    }

    private boolean isBinaryOperator(Token token) {
        return false;
    }

    public Vector RPN2Infix(Vector vector) {
        Vector vector2 = new Vector(15);
        ListIterator listIterator = vector.listIterator();
        Stack<Vector> stack = new Stack<Vector>();
        Stack stack2 = new Stack();
        while (listIterator.hasNext()) {
            Token token = (Token)listIterator.next();
            if (token.isOperand()) {
                Vector<Token> vector3 = new Vector<Token>(5);
                vector3.add(token);
                stack.push(vector3);
                continue;
            }
            if (!token.isOperator() && !token.isFunction()) continue;
            stack2.clear();
            for (int i = 0; i < token.getNumArgs(); ++i) {
                stack2.push(stack.pop());
            }
            stack.push(this.makeExpression(token, stack2));
        }
        return (Vector)stack.elementAt(0);
    }

    public Vector infix2RPN(Vector vector) {
        Token token;
        Vector<Object> vector2 = new Vector<Object>(15);
        Stack<Token> stack = new Stack<Token>();
        ListIterator listIterator = vector.listIterator();
        while (listIterator.hasNext()) {
            Object object;
            token = (Token)listIterator.next();
            if (token.isOperand()) {
                vector2.add(token);
                continue;
            }
            if (token.isFunction() || this.isParamDelimiter(token) || this.isOpenBrace(token)) {
                stack.push(token);
                if (token.isFunction()) {
                    listIterator.next();
                }
                object = this.extractParameter(listIterator);
                Debug.log((int)4, (String)("Extracted parameter " + object));
                vector2.addAll(this.infix2RPN((Vector)object));
                continue;
            }
            if (this.isCloseBrace(token)) {
                object = null;
                boolean bl = true;
                while (bl) {
                    if (stack.isEmpty()) {
                        bl = false;
                        continue;
                    }
                    object = (Token)stack.pop();
                    if (!this.isParamDelimiter((Token)object)) {
                        vector2.add(object);
                    }
                    if (!((Token)object).isFunction() && !this.isOpenBrace((Token)object)) continue;
                    bl = false;
                }
                continue;
            }
            if (!stack.isEmpty()) {
                while (!(stack.isEmpty() || ((Token)stack.peek()).getTokenPriority() < token.getTokenPriority() || ((Token)(object = (Token)stack.peek())).isFunction() || this.isOpenBrace((Token)object))) {
                    vector2.add(stack.pop());
                }
            }
            stack.push(token);
        }
        while (!stack.isEmpty()) {
            token = (Token)stack.peek();
            if (!this.isOpenBrace(token) && !this.isParamDelimiter(token)) {
                vector2.add(stack.pop());
                continue;
            }
            stack.pop();
        }
        return vector2;
    }

    protected Vector extractParameter(ListIterator listIterator) {
        Vector<Token> vector = new Vector<Token>(5);
        int n = 0;
        while (listIterator.hasNext()) {
            Token token = (Token)listIterator.next();
            Debug.log((int)4, (String)("Token is " + token + " and subExprCount is " + n));
            if (this.isOpenBrace(token)) {
                ++n;
                vector.add(token);
                continue;
            }
            if (this.isCloseBrace(token)) {
                if (n == 0) {
                    listIterator.previous();
                    return vector;
                }
                --n;
                vector.add(token);
                continue;
            }
            if (this.isParamDelimiter(token) && n == 0) {
                listIterator.previous();
                return vector;
            }
            vector.add(token);
        }
        return vector;
    }

    protected Vector makeExpression(Token token, Stack stack) {
        Vector<Token> vector = new Vector<Token>(5);
        TokenFactory tokenFactory = new TokenFactory();
        if (token.isOperator()) {
            if (token.getNumArgs() == 2) {
                vector.addAll((Vector)stack.pop());
                vector.add(token);
                vector.addAll((Vector)stack.pop());
            } else if (token.getNumArgs() == 1) {
                if (this.isPercent(token)) {
                    vector.addAll((Vector)stack.elementAt(0));
                    vector.add(token);
                } else {
                    vector.add(token);
                    vector.addAll((Vector)stack.elementAt(0));
                }
                if (this.isOpenBrace(token)) {
                    vector.add(tokenFactory.getOperatorToken(")", 1));
                }
            }
        } else if (token.isFunction()) {
            Vector vector2;
            vector.add(token);
            vector.add(tokenFactory.getOperatorToken("(", 1));
            if (!stack.isEmpty()) {
                vector2 = (Vector)stack.pop();
                vector.addAll(vector2);
            }
            while (!stack.isEmpty()) {
                vector.add(tokenFactory.getOperatorToken(",", 1));
                vector2 = (Vector)stack.pop();
                vector.addAll(vector2);
            }
            vector.add(tokenFactory.getOperatorToken(")", 1));
        }
        return vector;
    }
}

