/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula;

import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.formula.DefaultLocalizationContext;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaBoot;
import org.pentaho.reporting.libraries.formula.LocalizationContext;
import org.pentaho.reporting.libraries.formula.function.DefaultFunctionRegistry;
import org.pentaho.reporting.libraries.formula.function.FunctionRegistry;
import org.pentaho.reporting.libraries.formula.operators.DefaultOperatorFactory;
import org.pentaho.reporting.libraries.formula.operators.OperatorFactory;
import org.pentaho.reporting.libraries.formula.typing.DefaultTypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.coretypes.AnyType;

public class DefaultFormulaContext
implements FormulaContext {
    private DefaultTypeRegistry typeRegistry;
    private DefaultFunctionRegistry functionRegistry;
    private OperatorFactory operatorFactory;
    private DefaultLocalizationContext localizationContext;
    private Configuration config;
    private HashMap references;

    public DefaultFormulaContext() {
        this(LibFormulaBoot.getInstance().getGlobalConfig());
    }

    public DefaultFormulaContext(Configuration configuration) {
        this(configuration, null, null);
    }

    public DefaultFormulaContext(Configuration configuration, Locale locale, TimeZone timeZone) {
        if (configuration == null) {
            throw new NullPointerException();
        }
        this.config = configuration;
        this.localizationContext = new DefaultLocalizationContext();
        this.localizationContext.initialize(configuration, locale, timeZone);
        this.typeRegistry = new DefaultTypeRegistry();
        this.typeRegistry.initialize(this);
        this.functionRegistry = new DefaultFunctionRegistry();
        this.functionRegistry.initialize(configuration);
        this.operatorFactory = new DefaultOperatorFactory();
        this.operatorFactory.initalize(configuration);
    }

    public OperatorFactory getOperatorFactory() {
        return this.operatorFactory;
    }

    public void defineReference(Object object, Object object2) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (object2 == null) {
            if (this.references == null) {
                return;
            }
            this.references.remove(object);
            return;
        }
        if (this.references == null) {
            this.references = new HashMap();
        }
        this.references.put(object, object2);
    }

    public Object resolveReference(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (this.references == null) {
            return null;
        }
        return this.references.get(object);
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public FunctionRegistry getFunctionRegistry() {
        return this.functionRegistry;
    }

    public Type resolveReferenceType(Object object) {
        return AnyType.TYPE;
    }

    public TypeRegistry getTypeRegistry() {
        return this.typeRegistry;
    }

    public LocalizationContext getLocalizationContext() {
        return this.localizationContext;
    }

    public boolean isReferenceDirty(Object object) {
        return true;
    }
}

