/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.datetime;

import java.math.BigDecimal;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.coretypes.NumberType;
import org.pentaho.reporting.libraries.formula.util.NumberUtil;

public class HourFunction
implements Function {
    private static final BigDecimal HOUR_24 = new BigDecimal(24);
    private static final long serialVersionUID = 1877256236005061937L;

    public String getCanonicalName() {
        return "HOUR";
    }

    public TypeValuePair evaluate(FormulaContext formulaContext, ParameterCallback parameterCallback) throws EvaluationException {
        if (parameterCallback.getParameterCount() != 1) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        TypeRegistry typeRegistry = formulaContext.getTypeRegistry();
        Number number = typeRegistry.convertToNumber(parameterCallback.getType(0), parameterCallback.getValue(0));
        if (number == null) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        BigDecimal bigDecimal = NumberUtil.getAsBigDecimal(number);
        BigDecimal bigDecimal2 = new BigDecimal(NumberUtil.performIntRounding(bigDecimal).intValue());
        BigDecimal bigDecimal3 = bigDecimal.subtract(bigDecimal2);
        BigDecimal bigDecimal4 = bigDecimal3.multiply(HOUR_24);
        BigDecimal bigDecimal5 = NumberUtil.performIntRounding(bigDecimal4);
        return new TypeValuePair(NumberType.GENERIC_NUMBER, bigDecimal5);
    }
}

