/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.datetime;

import java.math.BigDecimal;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.coretypes.NumberType;
import org.pentaho.reporting.libraries.formula.util.NumberUtil;

public class SecondFunction
implements Function {
    private static final BigDecimal MINUTES_PER_DAY = new BigDecimal(1440);
    private static final BigDecimal SECONDS = new BigDecimal(60);

    public String getCanonicalName() {
        return "SECOND";
    }

    public TypeValuePair evaluate(FormulaContext formulaContext, ParameterCallback parameterCallback) throws EvaluationException {
        if (parameterCallback.getParameterCount() != 1) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        TypeRegistry typeRegistry = formulaContext.getTypeRegistry();
        Number number = typeRegistry.convertToNumber(parameterCallback.getType(0), parameterCallback.getValue(0));
        if (number == null) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        BigDecimal bigDecimal = NumberUtil.getAsBigDecimal(number);
        BigDecimal bigDecimal2 = bigDecimal.multiply(MINUTES_PER_DAY);
        BigDecimal bigDecimal3 = NumberUtil.performIntRounding(bigDecimal2);
        BigDecimal bigDecimal4 = bigDecimal2.subtract(bigDecimal3);
        BigDecimal bigDecimal5 = bigDecimal4.multiply(SECONDS);
        BigDecimal bigDecimal6 = NumberUtil.performIntRounding(bigDecimal5);
        return new TypeValuePair(NumberType.GENERIC_NUMBER, bigDecimal6);
    }
}

