/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.information;

import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Type;

public class ChooseFunction
implements Function {
    private static final long serialVersionUID = 5328221291584681439L;

    public String getCanonicalName() {
        return "CHOOSE";
    }

    public TypeValuePair evaluate(FormulaContext formulaContext, ParameterCallback parameterCallback) throws EvaluationException {
        if (parameterCallback.getParameterCount() <= 2) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        Type type = parameterCallback.getType(0);
        Object object = parameterCallback.getValue(0);
        int n = formulaContext.getTypeRegistry().convertToNumber(type, object).intValue();
        if (n < 1 || n >= parameterCallback.getParameterCount()) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        return new TypeValuePair(parameterCallback.getType(n), parameterCallback.getValue(n));
    }
}

