/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.operators;

import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.operators.InfixOperator;
import org.pentaho.reporting.libraries.formula.typing.ExtendedComparator;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.coretypes.LogicalType;

public abstract class AbstractCompareOperator
implements InfixOperator {
    private static final TypeValuePair RETURN_TRUE = new TypeValuePair(LogicalType.TYPE, Boolean.TRUE);
    private static final TypeValuePair RETURN_FALSE = new TypeValuePair(LogicalType.TYPE, Boolean.FALSE);
    private static final long serialVersionUID = 1375799912336916036L;

    protected AbstractCompareOperator() {
    }

    public final TypeValuePair evaluate(FormulaContext formulaContext, TypeValuePair typeValuePair, TypeValuePair typeValuePair2) throws EvaluationException {
        TypeRegistry typeRegistry = formulaContext.getTypeRegistry();
        Type type = typeValuePair.getType();
        Type type2 = typeValuePair2.getType();
        Object object = typeValuePair.getValue();
        Object object2 = typeValuePair2.getValue();
        if (object == null || object2 == null) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_NA_VALUE);
        }
        ExtendedComparator extendedComparator = typeRegistry.getComparator(type, type2);
        int n = extendedComparator.compare(type, object, type2, object2);
        if (this.evaluate(n)) {
            return RETURN_TRUE;
        }
        return RETURN_FALSE;
    }

    protected abstract boolean evaluate(int var1);
}

