/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.operators;

import java.util.HashMap;
import java.util.Iterator;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.formula.operators.InfixOperator;
import org.pentaho.reporting.libraries.formula.operators.OperatorFactory;
import org.pentaho.reporting.libraries.formula.operators.PostfixOperator;
import org.pentaho.reporting.libraries.formula.operators.PrefixOperator;

public class DefaultOperatorFactory
implements OperatorFactory {
    private static final String INFIX_PREFIX = "org.pentaho.reporting.libraries.formula.operators.infix.";
    private static final String PREFIX_PREFIX = "org.pentaho.reporting.libraries.formula.operators.prefix.";
    private static final String POSTFIX_PREFIX = "org.pentaho.reporting.libraries.formula.operators.postfix.";
    private HashMap infixOperators = new HashMap();
    private HashMap prefixOperators = new HashMap();
    private HashMap postfixOperators = new HashMap();

    public void initalize(Configuration configuration) {
        this.loadInfixOperators(configuration);
        this.loadPrefixOperators(configuration);
        this.loadPostfixOperators(configuration);
    }

    private void loadInfixOperators(Configuration configuration) {
        Iterator iterator = configuration.findPropertyKeys(INFIX_PREFIX);
        while (iterator.hasNext()) {
            String string;
            String string2;
            String string3;
            String string4 = (String)iterator.next();
            if (!string4.endsWith(".class") || (string3 = configuration.getConfigProperty(string4)) == null || string3.length() == 0 || (string2 = configuration.getConfigProperty(string = string4.substring(0, string4.length() - ".class".length()) + ".token")) == null) continue;
            String string5 = string2.trim();
            Object object = ObjectUtilities.loadAndInstantiate((String)string3, DefaultOperatorFactory.class, InfixOperator.class);
            if (!(object instanceof InfixOperator)) continue;
            this.infixOperators.put(string5, object);
        }
    }

    private void loadPrefixOperators(Configuration configuration) {
        Iterator iterator = configuration.findPropertyKeys(PREFIX_PREFIX);
        while (iterator.hasNext()) {
            String string;
            String string2;
            String string3;
            String string4 = (String)iterator.next();
            if (!string4.endsWith(".class") || (string3 = configuration.getConfigProperty(string4)) == null || string3.length() == 0 || (string2 = configuration.getConfigProperty(string = string4.substring(0, string4.length() - ".class".length()) + ".token")) == null) continue;
            String string5 = string2.trim();
            Object object = ObjectUtilities.loadAndInstantiate((String)string3, DefaultOperatorFactory.class, PrefixOperator.class);
            if (!(object instanceof PrefixOperator)) continue;
            this.prefixOperators.put(string5, object);
        }
    }

    private void loadPostfixOperators(Configuration configuration) {
        Iterator iterator = configuration.findPropertyKeys(POSTFIX_PREFIX);
        while (iterator.hasNext()) {
            String string;
            String string2;
            String string3;
            String string4 = (String)iterator.next();
            if (!string4.endsWith(".class") || (string3 = configuration.getConfigProperty(string4)) == null || string3.length() == 0 || (string2 = configuration.getConfigProperty(string = string4.substring(0, string4.length() - ".class".length()) + ".token")) == null) continue;
            String string5 = string2.trim();
            Object object = ObjectUtilities.loadAndInstantiate((String)string3, DefaultOperatorFactory.class, PostfixOperator.class);
            if (!(object instanceof PostfixOperator)) continue;
            this.postfixOperators.put(string5, object);
        }
    }

    public InfixOperator createInfixOperator(String string) {
        return (InfixOperator)this.infixOperators.get(string);
    }

    public PostfixOperator createPostfixOperator(String string) {
        return (PostfixOperator)this.postfixOperators.get(string);
    }

    public PrefixOperator createPrefixOperator(String string) {
        return (PrefixOperator)this.prefixOperators.get(string);
    }
}

