/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.util;

import java.math.BigDecimal;
import java.util.Date;
import java.util.GregorianCalendar;
import org.pentaho.reporting.libraries.formula.LibFormulaBoot;
import org.pentaho.reporting.libraries.formula.util.NumberUtil;

public class HSSFDateUtil {
    private static final BigDecimal DAY_MILLISECONDS = new BigDecimal(86400000);
    private static final int DAYS_TO_1900 = HSSFDateUtil.daysInPriorYears(1899) + 1;

    private HSSFDateUtil() {
    }

    public static int computeZeroDate(String string, boolean bl) {
        if ("1899".equals(string)) {
            return 2;
        }
        if ("1900".equals(string)) {
            return 0;
        }
        if (bl) {
            return -1461;
        }
        return -1460;
    }

    public static BigDecimal getExcelDate(Date date) {
        String string = LibFormulaBoot.getInstance().getGlobalConfig().getConfigProperty("org.pentaho.reporting.libraries.formula.ZeroDate", "1900");
        boolean bl = "true".equals(LibFormulaBoot.getInstance().getGlobalConfig().getConfigProperty("org.pentaho.reporting.libraries.formula.ExcelDateBugAware", "false"));
        return HSSFDateUtil.getExcelDate(date, bl, HSSFDateUtil.computeZeroDate(string, bl));
    }

    public static BigDecimal getExcelDate(Date date, boolean bl, int n) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        long l = gregorianCalendar.get(11);
        l = l * 60L + (long)gregorianCalendar.get(12);
        l = l * 60L + (long)gregorianCalendar.get(13);
        l = l * 1000L + (long)gregorianCalendar.get(14);
        BigDecimal bigDecimal = new BigDecimal(l).divide(DAY_MILLISECONDS, 40, 4);
        int n2 = gregorianCalendar.get(1);
        int n3 = gregorianCalendar.get(6);
        if (bl) {
            if (n > 59) {
                if (n2 < 1900 || n2 == 1900 && n3 > 59) {
                    ++n3;
                }
            } else if (n2 > 1900 || n2 == 1900 && n3 > 59) {
                ++n3;
            }
        }
        int n4 = HSSFDateUtil.daysInPriorYears(n2 - 1) - DAYS_TO_1900;
        int n5 = n3 + n4;
        return bigDecimal.add(new BigDecimal(n5 + n));
    }

    private static int daysInPriorYears(int n) {
        return 365 * n + n / 4 - n / 100 + n / 400;
    }

    public static Date getJavaDate(BigDecimal bigDecimal) {
        String string = LibFormulaBoot.getInstance().getGlobalConfig().getConfigProperty("org.pentaho.reporting.libraries.formula.ZeroDate", "1900");
        boolean bl = "true".equals(LibFormulaBoot.getInstance().getGlobalConfig().getConfigProperty("org.pentaho.reporting.libraries.formula.ExcelDateBugAware", "false"));
        return HSSFDateUtil.getJavaDate(bigDecimal, bl, HSSFDateUtil.computeZeroDate(string, bl));
    }

    public static Date getJavaDate(BigDecimal bigDecimal, boolean bl, int n) {
        int n2 = 1;
        BigDecimal bigDecimal2 = NumberUtil.performIntRounding(bigDecimal);
        int n3 = bigDecimal2.intValue() - n;
        if (bl && n3 > 59) {
            n2 = 0;
        }
        BigDecimal bigDecimal3 = bigDecimal.subtract(bigDecimal2);
        BigDecimal bigDecimal4 = bigDecimal3.multiply(DAY_MILLISECONDS);
        GregorianCalendar gregorianCalendar = new GregorianCalendar(1900, 0, n3 + n2);
        gregorianCalendar.set(14, bigDecimal4.setScale(0, 4).intValue());
        return gregorianCalendar.getTime();
    }
}

