/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.util;

import java.math.BigDecimal;

public class NumberUtil {
    public static final BigDecimal DELTA = new BigDecimal("0.000000000000000000000000000000000000005");
    public static final BigDecimal INT_TEST_DELTA = new BigDecimal("0.00000000000000000000000000000000005");
    private static final int ROUND_SCALE = 34;

    private NumberUtil() {
    }

    public static BigDecimal getAsBigDecimal(Number number) {
        if (number == null) {
            throw new NullPointerException();
        }
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        return new BigDecimal(number.toString());
    }

    public static BigDecimal performIntRounding(BigDecimal bigDecimal) {
        try {
            return bigDecimal.setScale(0);
        }
        catch (ArithmeticException arithmeticException) {
            BigDecimal bigDecimal2;
            if (bigDecimal.signum() < 0) {
                bigDecimal = bigDecimal.subtract(DELTA);
                bigDecimal2 = bigDecimal.setScale(0, 0);
            } else {
                bigDecimal = bigDecimal.add(DELTA);
                bigDecimal2 = bigDecimal.setScale(1, 1);
            }
            return new BigDecimal(bigDecimal2.intValue());
        }
    }

    public static BigDecimal performTuneRounding(BigDecimal bigDecimal) {
        try {
            bigDecimal.setScale(34);
            return bigDecimal;
        }
        catch (ArithmeticException arithmeticException) {
            BigDecimal bigDecimal2;
            if (bigDecimal.signum() < 0) {
                bigDecimal = bigDecimal.subtract(INT_TEST_DELTA);
                bigDecimal2 = bigDecimal.setScale(34, 0);
            } else {
                bigDecimal = bigDecimal.add(INT_TEST_DELTA);
                bigDecimal2 = bigDecimal.setScale(34, 1);
            }
            if (bigDecimal.compareTo(bigDecimal2) == 0) {
                return bigDecimal;
            }
            return NumberUtil.removeTrailingZeros(bigDecimal2);
        }
    }

    public static BigDecimal removeTrailingZeros(BigDecimal bigDecimal) {
        char c;
        if (bigDecimal.signum() == 0) {
            return bigDecimal.setScale(0);
        }
        String string = bigDecimal.toString();
        int n = bigDecimal.scale();
        for (int i = string.length() - 1; i >= 0 && (c = string.charAt(i)) == '0'; --i) {
            --n;
        }
        return bigDecimal.setScale(n);
    }
}

