/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxw.pocketword;

import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.openoffice.xmerge.converter.xml.ParaStyle;
import org.openoffice.xmerge.converter.xml.TextStyle;
import org.openoffice.xmerge.converter.xml.sxw.pocketword.ParagraphTextSegment;
import org.openoffice.xmerge.converter.xml.sxw.pocketword.PocketWordConstants;
import org.openoffice.xmerge.util.ColourConverter;
import org.openoffice.xmerge.util.EndianConverter;

class Paragraph
implements PocketWordConstants {
    private static short unknown1 = (short)35;
    private short dataWords = 0;
    private short textLength = 0;
    private short lengthWithFormatting = 0;
    private short lines = 0;
    private static final short marker = -1;
    private static int unknown2 = 34;
    private short specialIndentation = 0;
    private short leftIndentation = 0;
    private short rightIndentation = 0;
    private byte bullets = 0;
    private byte alignment = 0;
    private static int unknown3 = 0;
    private short defaultFont = (short)2;
    private short defaultSize = (short)10;
    private Vector textSegments = new Vector(0, 1);
    private Vector lineDescriptors = null;
    private ParaStyle pStyle = null;
    private boolean isLastParagraph = false;

    private Paragraph() {
    }

    public Paragraph(ParaStyle paraStyle) {
        this();
        this.lineDescriptors = new Vector(0, 1);
        this.pStyle = paraStyle;
    }

    public Paragraph(byte[] byArray) {
        this();
        this.dataWords = EndianConverter.readShort((byte[])new byte[]{byArray[2], byArray[3]});
        this.textLength = EndianConverter.readShort((byte[])new byte[]{byArray[4], byArray[5]});
        this.lengthWithFormatting = EndianConverter.readShort((byte[])new byte[]{byArray[6], byArray[7]});
        this.lines = EndianConverter.readShort((byte[])new byte[]{byArray[8], byArray[9]});
        this.specialIndentation = EndianConverter.readShort((byte[])new byte[]{byArray[16], byArray[17]});
        this.leftIndentation = EndianConverter.readShort((byte[])new byte[]{byArray[18], byArray[19]});
        this.rightIndentation = EndianConverter.readShort((byte[])new byte[]{byArray[20], byArray[21]});
        this.bullets = byArray[22];
        this.alignment = byArray[23];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(byArray, 28, this.lengthWithFormatting);
        this.parseText(byteArrayOutputStream.toByteArray());
    }

    private void parseText(byte[] byArray) {
        int n = byArray.length;
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = 15;
        String string = null;
        int n3 = 0;
        Color color = null;
        Color color2 = null;
        int n4 = 0;
        TextStyle textStyle = null;
        int n5 = 0;
        boolean bl = false;
        boolean bl2 = false;
        String string2 = new String();
        for (int i = 0; i < n; ++i) {
            if ((byte)(byArray[i] & 0xF0) == -32) {
                if (bl2) {
                    this.addTextSegment(stringBuffer.toString(), textStyle);
                    stringBuffer = new StringBuffer("");
                    bl2 = false;
                }
                switch (byArray[i]) {
                    case -27: {
                        short s = EndianConverter.readShort((byte[])new byte[]{byArray[i + 1], byArray[i + 2]});
                        if (string == null || string.equals("2")) {
                            if (s != 2 && s != 1) {
                                string = String.valueOf(s);
                                ++n5;
                            }
                        } else if (s == 2 || s == 1) {
                            string = "2";
                            --n5;
                        } else {
                            string = String.valueOf(s);
                        }
                        i += 2;
                        break;
                    }
                    case -26: {
                        short s = EndianConverter.readShort((byte[])new byte[]{byArray[i + 1], byArray[i + 2]});
                        if (s == 0) {
                            this.isLastParagraph = true;
                            i += 2;
                            break;
                        }
                        if (n3 == 0 || n3 == 10) {
                            if (s != 10) {
                                n3 = s;
                                ++n5;
                            }
                        } else if (s == 10) {
                            n3 = 10;
                            --n5;
                        } else {
                            n3 = s;
                        }
                        i += 2;
                        break;
                    }
                    case -25: {
                        if (byArray[i + 1] != 0) {
                            ColourConverter colourConverter = new ColourConverter();
                            color = colourConverter.convertToRGB(EndianConverter.readShort((byte[])new byte[]{byArray[i + 1], byArray[i + 2]}));
                            ++n5;
                        } else {
                            color = null;
                            --n5;
                        }
                        i += 2;
                        break;
                    }
                    case -24: {
                        if (byArray[i + 1] == 7 || byArray[i + 1] == 9) {
                            n4 |= 1;
                            ++n5;
                        } else {
                            n4 ^= 1;
                            --n5;
                        }
                        i += 2;
                        break;
                    }
                    case -23: {
                        if (byArray[i + 1] == 1) {
                            n4 |= 2;
                            ++n5;
                        } else {
                            n4 ^= 2;
                            --n5;
                        }
                        ++i;
                        break;
                    }
                    case -22: {
                        if (byArray[i + 1] == 1) {
                            n4 |= 4;
                            ++n5;
                        } else {
                            n4 ^= 4;
                            --n5;
                        }
                        ++i;
                        break;
                    }
                    case -21: {
                        if (byArray[i + 1] == 1) {
                            n4 |= 8;
                            ++n5;
                        } else {
                            n4 ^= 8;
                            --n5;
                        }
                        ++i;
                        break;
                    }
                    case -20: {
                        if (byArray[i + 1] == 1) {
                            color2 = Color.yellow;
                            ++n5;
                        } else {
                            color2 = null;
                            --n5;
                        }
                        ++i;
                    }
                }
                bl = true;
                continue;
            }
            if (bl) {
                bl = false;
                if (n5 > 0) {
                    textStyle = new TextStyle(null, "text", "Standard", n2, n4, n3, string, null);
                    textStyle.setColors(color, color2);
                } else {
                    textStyle = null;
                }
            }
            if (byArray[i] == -60) {
                if (byArray[i + 1] == 0) {
                    if (this.isLastParagraph && this.textSegments.size() > 0) {
                        return;
                    }
                    this.addTextSegment(stringBuffer.toString(), textStyle);
                    return;
                }
                stringBuffer.append("\t");
                bl2 = true;
                ++i;
                continue;
            }
            stringBuffer.append((char)byArray[i]);
            bl2 = true;
            string2 = stringBuffer.toString();
        }
    }

    public void addTextSegment(String string, TextStyle textStyle) {
        this.textLength = (short)(this.textLength + string.length());
        this.textSegments.add(new ParagraphTextSegment(string, textStyle));
    }

    public void setLastParagraph(boolean bl) {
        this.isLastParagraph = bl;
    }

    public boolean getLastParagraph() {
        return this.isLastParagraph;
    }

    public byte[] getParagraphData() {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.postProcessText();
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        try {
            for (n = 0; n < this.textSegments.size(); ++n) {
                ParagraphTextSegment paragraphTextSegment = (ParagraphTextSegment)this.textSegments.elementAt(n);
                byteArrayOutputStream2.write(paragraphTextSegment.getData());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.dataWords = (short)(26 + byteArrayOutputStream2.size() + 3 + 4);
        if (this.isLastParagraph) {
            this.dataWords = (short)(this.dataWords + 6);
        }
        if (this.dataWords % 4 != 0) {
            this.dataWords = (short)(this.dataWords + (4 - this.dataWords % 4));
        }
        this.dataWords = (short)(this.dataWords / 4);
        this.lengthWithFormatting = (short)(byteArrayOutputStream2.size() + (this.isLastParagraph ? 14 : 8));
        try {
            int n2;
            byteArrayOutputStream.write(EndianConverter.writeShort((short)unknown1));
            byteArrayOutputStream.write(EndianConverter.writeShort((short)this.dataWords));
            byteArrayOutputStream.write(EndianConverter.writeShort((short)((short)(this.textLength + 1))));
            byteArrayOutputStream.write(EndianConverter.writeShort((short)this.lengthWithFormatting));
            byteArrayOutputStream.write(EndianConverter.writeShort((short)this.lines));
            byteArrayOutputStream.write(EndianConverter.writeShort((short)-1));
            byteArrayOutputStream.write(EndianConverter.writeInt((int)unknown2));
            byteArrayOutputStream.write(EndianConverter.writeShort((short)this.specialIndentation));
            byteArrayOutputStream.write(EndianConverter.writeShort((short)this.leftIndentation));
            byteArrayOutputStream.write(EndianConverter.writeShort((short)this.rightIndentation));
            byteArrayOutputStream.write(this.bullets);
            if (this.pStyle != null && this.pStyle.isAttributeSet(6)) {
                switch (this.pStyle.getAttribute(6)) {
                    case 1: {
                        byteArrayOutputStream.write(1);
                        break;
                    }
                    case 2: {
                        byteArrayOutputStream.write(2);
                        break;
                    }
                    default: {
                        byteArrayOutputStream.write(0);
                        break;
                    }
                }
            } else {
                byteArrayOutputStream.write(0);
            }
            byteArrayOutputStream.write(EndianConverter.writeInt((int)unknown3));
            byteArrayOutputStream.write(-27);
            byteArrayOutputStream.write(EndianConverter.writeShort((short)this.defaultFont));
            byteArrayOutputStream.write(-26);
            byteArrayOutputStream.write(EndianConverter.writeShort((short)this.defaultSize));
            byteArrayOutputStream.write(byteArrayOutputStream2.toByteArray());
            if (this.isLastParagraph) {
                if (this.defaultFont != 1) {
                    byteArrayOutputStream.write(-27);
                    byteArrayOutputStream.write(EndianConverter.writeShort((short)1));
                }
                byteArrayOutputStream.write(-26);
                byteArrayOutputStream.write(EndianConverter.writeShort((short)0));
            }
            byteArrayOutputStream.write(new byte[]{-60, 0, 0});
            n = 0;
            if (byteArrayOutputStream.size() % 4 != 0) {
                n = 4 - byteArrayOutputStream.size() % 4;
            }
            for (n2 = 0; n2 < n; ++n2) {
                byteArrayOutputStream.write(0);
            }
            byteArrayOutputStream.write(new byte[]{66, 0, 34, 0});
            n2 = this.lineDescriptors.size() * 10 / 4;
            if (this.lineDescriptors.size() * 10 % 4 != 0) {
                ++n2;
            }
            byteArrayOutputStream.write(EndianConverter.writeShort((short)((short)n2)));
            for (int i = 0; i < this.lineDescriptors.size(); ++i) {
                LineDescriptor lineDescriptor = (LineDescriptor)this.lineDescriptors.elementAt(i);
                byteArrayOutputStream.write(lineDescriptor.getDescriptorInfo());
            }
            if (!this.isLastParagraph) {
                if (byteArrayOutputStream.size() % 4 != 2) {
                    byteArrayOutputStream.write(EndianConverter.writeShort((short)0));
                }
                byteArrayOutputStream.write(EndianConverter.writeShort((short)65));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }

    private void postProcessText() {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer("");
        this.lineDescriptors = new Vector(1, 1);
        this.lines = 0;
        for (int i = 0; i < this.textSegments.size(); ++i) {
            ParagraphTextSegment paragraphTextSegment = (ParagraphTextSegment)this.textSegments.elementAt(i);
            stringBuffer.append(paragraphTextSegment.getText());
        }
        if (stringBuffer.length() == 0) {
            this.lines = 1;
            this.lineDescriptors.add(new LineDescriptor(1, 0));
            return;
        }
        while (n < stringBuffer.length()) {
            String string = "";
            try {
                string = stringBuffer.substring(n, n + 30);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                string = stringBuffer.substring(n);
                this.lineDescriptors.add(new LineDescriptor((short)(string.length() + 1), (short)(string.length() * 36)));
                n += string.length();
                this.lines = (short)(this.lines + 1);
                continue;
            }
            int n2 = -1;
            for (int i = 29; i >= 0; --i) {
                if (!Character.isWhitespace(string.charAt(i))) continue;
                n2 = i;
                break;
            }
            if (n2 != -1) {
                this.lineDescriptors.add(new LineDescriptor((short)(n2 + 1), (short)(n2 * 36)));
                n += n2 + 1;
                this.lines = (short)(this.lines + 1);
                continue;
            }
            this.lineDescriptors.add(new LineDescriptor(29, 1044));
            n += 29;
            this.lines = (short)(this.lines + 1);
        }
    }

    public short getLines() {
        this.postProcessText();
        return this.lines;
    }

    public void setBullets(boolean bl) {
        this.bullets = bl ? (byte)-1 : (byte)0;
    }

    public boolean isBulleted() {
        return this.bullets != 0;
    }

    public int getTextLength() {
        return this.textLength;
    }

    public Enumeration getSegmentsEnumerator() {
        return this.textSegments.elements();
    }

    public ParaStyle makeStyle() {
        int[] nArray = new int[]{0, 1, 6};
        String[] stringArray = new String[nArray.length];
        switch (this.alignment) {
            case 2: {
                stringArray[2] = "center";
                break;
            }
            case 1: {
                stringArray[2] = "right";
                break;
            }
            default: {
                stringArray[2] = "left";
                return null;
            }
        }
        return new ParaStyle(null, "paragraph", null, nArray, stringArray, null);
    }

    private class LineDescriptor {
        private short characters = 0;
        private int filler = 0;
        private short screen_space = 0;
        private short marker = 0;

        private LineDescriptor(short s, short s2) {
            this.characters = s;
            this.screen_space = s2;
            this.marker = (short)1036;
        }

        private byte[] getDescriptorInfo() {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                byteArrayOutputStream.write(EndianConverter.writeShort((short)this.characters));
                byteArrayOutputStream.write(EndianConverter.writeInt((int)this.filler));
                byteArrayOutputStream.write(EndianConverter.writeShort((short)this.screen_space));
                byteArrayOutputStream.write(EndianConverter.writeShort((short)this.marker));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return byteArrayOutputStream.toByteArray();
        }
    }
}

