/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.resourceloader;

import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.resourceloader.DefaultResourceManagerBackend;
import org.pentaho.reporting.libraries.resourceloader.LibLoaderBoot;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceBundleData;
import org.pentaho.reporting.libraries.resourceloader.ResourceBundleLoader;
import org.pentaho.reporting.libraries.resourceloader.ResourceCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceFactory;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoader;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManagerBackend;
import org.pentaho.reporting.libraries.resourceloader.UnrecognizedLoaderException;
import org.pentaho.reporting.libraries.resourceloader.cache.NullResourceBundleDataCache;
import org.pentaho.reporting.libraries.resourceloader.cache.NullResourceDataCache;
import org.pentaho.reporting.libraries.resourceloader.cache.NullResourceFactoryCache;
import org.pentaho.reporting.libraries.resourceloader.cache.ResourceBundleDataCache;
import org.pentaho.reporting.libraries.resourceloader.cache.ResourceBundleDataCacheEntry;
import org.pentaho.reporting.libraries.resourceloader.cache.ResourceBundleDataCacheProvider;
import org.pentaho.reporting.libraries.resourceloader.cache.ResourceDataCache;
import org.pentaho.reporting.libraries.resourceloader.cache.ResourceDataCacheEntry;
import org.pentaho.reporting.libraries.resourceloader.cache.ResourceDataCacheProvider;
import org.pentaho.reporting.libraries.resourceloader.cache.ResourceFactoryCache;
import org.pentaho.reporting.libraries.resourceloader.cache.ResourceFactoryCacheProvider;

public final class ResourceManager {
    private static Log logger = LogFactory.getLog(ResourceManager.class);
    private ResourceManagerBackend backend;
    public static final String BUNDLE_LOADER_PREFIX = "org.pentaho.reporting.libraries.resourceloader.bundle.loader.";
    public static final String LOADER_PREFIX = "org.pentaho.reporting.libraries.resourceloader.loader.";
    public static final String FACTORY_TYPE_PREFIX = "org.pentaho.reporting.libraries.resourceloader.factory.type.";
    public static final String BUNDLE_CACHE_PROVIDER_KEY = "org.pentaho.reporting.libraries.resourceloader.cache.BundleDataCacheProvider";
    public static final String DATA_CACHE_PROVIDER_KEY = "org.pentaho.reporting.libraries.resourceloader.cache.DataCacheProvider";
    public static final String FACTORY_CACHE_PROVIDER_KEY = "org.pentaho.reporting.libraries.resourceloader.cache.FactoryCacheProvider";
    private ResourceDataCache dataCache;
    private ResourceBundleDataCache bundleCache;
    private ResourceFactoryCache factoryCache;
    private static final Set failedModules = new HashSet();

    public ResourceManager() {
        this(new DefaultResourceManagerBackend());
    }

    public ResourceManager(ResourceManagerBackend resourceManagerBackend) {
        if (resourceManagerBackend == null) {
            throw new NullPointerException();
        }
        this.backend = resourceManagerBackend;
        this.bundleCache = new NullResourceBundleDataCache();
        this.dataCache = new NullResourceDataCache();
        this.factoryCache = new NullResourceFactoryCache();
    }

    public ResourceManager(ResourceManager resourceManager, ResourceManagerBackend resourceManagerBackend) {
        if (resourceManagerBackend == null) {
            throw new NullPointerException();
        }
        if (resourceManager == null) {
            throw new NullPointerException();
        }
        this.backend = resourceManagerBackend;
        this.bundleCache = resourceManager.getBundleCache();
        this.dataCache = resourceManager.getDataCache();
        this.factoryCache = resourceManager.getFactoryCache();
    }

    public ResourceManagerBackend getBackend() {
        return this.backend;
    }

    public ResourceKey createKey(Object object) throws ResourceKeyCreationException {
        return this.createKey(object, null);
    }

    public ResourceKey createKey(Object object, Map map) throws ResourceKeyCreationException {
        return this.backend.createKey(object, map);
    }

    public ResourceKey deriveKey(ResourceKey resourceKey, String string) throws ResourceKeyCreationException {
        return this.deriveKey(resourceKey, string, null);
    }

    public ResourceKey deriveKey(ResourceKey resourceKey, String string, Map map) throws ResourceKeyCreationException {
        return this.backend.deriveKey(resourceKey, string, map);
    }

    public URL toURL(ResourceKey resourceKey) {
        return this.backend.toURL(resourceKey);
    }

    public Resource createDirectly(Object object, Class clazz) throws ResourceLoadingException, ResourceCreationException, ResourceKeyCreationException {
        ResourceKey resourceKey = this.createKey(object);
        return this.create(resourceKey, null, clazz);
    }

    public synchronized ResourceBundleData loadResourceBundle(ResourceKey resourceKey) throws ResourceLoadingException {
        ResourceBundleData resourceBundleData;
        ResourceBundleDataCache resourceBundleDataCache = this.getBundleCache();
        ResourceBundleDataCacheEntry resourceBundleDataCacheEntry = resourceBundleDataCache.get(resourceKey);
        if (resourceBundleDataCacheEntry != null) {
            ResourceData resourceData;
            ResourceDataCacheEntry resourceDataCacheEntry;
            resourceBundleData = resourceBundleDataCacheEntry.getData();
            long l = resourceBundleData.getVersion(this);
            if ((resourceBundleDataCacheEntry.getStoredVersion() < 0L || l >= 0L && resourceBundleDataCacheEntry.getStoredVersion() == l) && (resourceDataCacheEntry = this.getDataCache().get(resourceBundleData.getBundleKey())) != null && (resourceData = resourceDataCacheEntry.getData()) != null) {
                if (this.isValidData(resourceDataCacheEntry, resourceData)) {
                    return resourceBundleData;
                }
                this.getDataCache().remove(resourceData);
            }
            resourceBundleDataCache.remove(resourceBundleData);
        }
        if ((resourceBundleData = this.backend.loadResourceBundle(this, resourceKey)) != null) {
            resourceBundleDataCache.put(this, resourceBundleData);
        }
        return resourceBundleData;
    }

    public ResourceData load(ResourceKey resourceKey) throws ResourceLoadingException {
        ResourceBundleData resourceBundleData;
        ResourceBundleData resourceBundleData2 = this.loadResourceBundle(resourceKey);
        if (resourceBundleData2 != null) {
            logger.debug((Object)("Loaded bundle for key " + resourceKey));
            return resourceBundleData2;
        }
        ResourceKey resourceKey2 = resourceKey.getParent();
        if (resourceKey2 != null && (resourceBundleData = this.loadResourceBundle(resourceKey2)) != null) {
            logger.debug((Object)("Loaded bundle for key (derivate) " + resourceKey));
            return resourceBundleData.deriveData(resourceKey);
        }
        return this.loadRawData(resourceKey);
    }

    private boolean isValidData(ResourceDataCacheEntry resourceDataCacheEntry, ResourceData resourceData) throws ResourceLoadingException {
        if (resourceDataCacheEntry.getStoredVersion() < 0L) {
            return true;
        }
        long l = resourceData.getVersion(this);
        if (l < 0L) {
            return false;
        }
        return resourceDataCacheEntry.getStoredVersion() == l;
    }

    public synchronized ResourceData loadRawData(ResourceKey resourceKey) throws UnrecognizedLoaderException, ResourceLoadingException {
        ResourceData resourceData;
        ResourceDataCache resourceDataCache = this.getDataCache();
        ResourceDataCacheEntry resourceDataCacheEntry = resourceDataCache.get(resourceKey);
        if (resourceDataCacheEntry != null && (resourceData = resourceDataCacheEntry.getData()) != null) {
            if (this.isValidData(resourceDataCacheEntry, resourceData)) {
                return resourceData;
            }
            resourceDataCache.remove(resourceData);
        }
        resourceData = this.backend.loadRawData(this, resourceKey);
        resourceDataCache.put(this, resourceData);
        return resourceData;
    }

    public Resource create(ResourceKey resourceKey, ResourceKey resourceKey2, Class clazz) throws ResourceLoadingException, ResourceCreationException {
        if (clazz == null) {
            throw new NullPointerException("Target must not be null");
        }
        if (resourceKey == null) {
            throw new NullPointerException("Key must not be null.");
        }
        return this.create(resourceKey, resourceKey2, new Class[]{clazz});
    }

    public Resource create(ResourceKey resourceKey, ResourceKey resourceKey2) throws ResourceLoadingException, ResourceCreationException {
        return this.create(resourceKey, resourceKey2, (Class[])null);
    }

    public Resource create(ResourceKey resourceKey, ResourceKey resourceKey2, Class[] classArray) throws ResourceLoadingException, ResourceCreationException {
        if (resourceKey == null) {
            throw new NullPointerException();
        }
        ResourceFactoryCache resourceFactoryCache = this.getFactoryCache();
        Resource resource = resourceFactoryCache.get(resourceKey);
        if (resource != null) {
            if (this.backend.isResourceUnchanged(this, resource)) {
                return resource;
            }
            resourceFactoryCache.remove(resource);
        }
        ResourceData resourceData = this.load(resourceKey);
        Resource resource2 = this.backend.create(this, resourceData, resourceKey2, classArray);
        resourceFactoryCache.put(resource2);
        return resource2;
    }

    public ResourceDataCache getDataCache() {
        return this.dataCache;
    }

    public void setDataCache(ResourceDataCache resourceDataCache) {
        if (resourceDataCache == null) {
            throw new NullPointerException();
        }
        this.dataCache = resourceDataCache;
    }

    public ResourceFactoryCache getFactoryCache() {
        return this.factoryCache;
    }

    public void setFactoryCache(ResourceFactoryCache resourceFactoryCache) {
        if (resourceFactoryCache == null) {
            throw new NullPointerException();
        }
        this.factoryCache = resourceFactoryCache;
    }

    public ResourceBundleDataCache getBundleCache() {
        return this.bundleCache;
    }

    public void setBundleCache(ResourceBundleDataCache resourceBundleDataCache) {
        if (resourceBundleDataCache == null) {
            throw new NullPointerException();
        }
        this.bundleCache = resourceBundleDataCache;
    }

    public void registerDefaults() {
        this.registerDefaultLoaders();
        this.registerDefaultFactories();
        this.registerDataCache();
        this.registerBundleDataCache();
        this.registerFactoryCache();
    }

    public void registerDefaultFactories() {
        this.backend.registerDefaultFactories();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerBundleDataCache() {
        Configuration configuration = LibLoaderBoot.getInstance().getGlobalConfig();
        String string = configuration.getConfigProperty(BUNDLE_CACHE_PROVIDER_KEY);
        if (string == null) {
            return;
        }
        Object object = ObjectUtilities.loadAndInstantiate((String)string, ResourceManager.class, ResourceBundleDataCacheProvider.class);
        if (object == null) {
            return;
        }
        ResourceBundleDataCacheProvider resourceBundleDataCacheProvider = (ResourceBundleDataCacheProvider)object;
        try {
            ResourceBundleDataCache resourceBundleDataCache = resourceBundleDataCacheProvider.createBundleDataCache();
            if (resourceBundleDataCache != null) {
                this.setBundleCache(resourceBundleDataCache);
            }
        }
        catch (Throwable throwable) {
            Set set = failedModules;
            synchronized (set) {
                if (!failedModules.contains(string)) {
                    logger.warn((Object)("Failed to create data cache: " + throwable.getLocalizedMessage()));
                    failedModules.add(string);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDataCache() {
        Configuration configuration = LibLoaderBoot.getInstance().getGlobalConfig();
        String string = configuration.getConfigProperty(DATA_CACHE_PROVIDER_KEY);
        if (string == null) {
            return;
        }
        Object object = ObjectUtilities.loadAndInstantiate((String)string, ResourceManager.class, ResourceDataCacheProvider.class);
        if (object instanceof ResourceDataCacheProvider) {
            ResourceDataCacheProvider resourceDataCacheProvider = (ResourceDataCacheProvider)object;
            try {
                ResourceDataCache resourceDataCache = resourceDataCacheProvider.createDataCache();
                if (resourceDataCache != null) {
                    this.setDataCache(resourceDataCache);
                }
            }
            catch (Throwable throwable) {
                Set set = failedModules;
                synchronized (set) {
                    if (!failedModules.contains(string)) {
                        logger.warn((Object)("Failed to create data cache: " + throwable.getLocalizedMessage()));
                        failedModules.add(string);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFactoryCache() {
        Configuration configuration = LibLoaderBoot.getInstance().getGlobalConfig();
        String string = configuration.getConfigProperty(FACTORY_CACHE_PROVIDER_KEY);
        if (string == null) {
            return;
        }
        Object object = ObjectUtilities.loadAndInstantiate((String)string, ResourceManager.class, ResourceFactoryCacheProvider.class);
        if (object != null) {
            ResourceFactoryCacheProvider resourceFactoryCacheProvider = (ResourceFactoryCacheProvider)object;
            try {
                ResourceFactoryCache resourceFactoryCache = resourceFactoryCacheProvider.createFactoryCache();
                if (resourceFactoryCache != null) {
                    this.setFactoryCache(resourceFactoryCache);
                }
            }
            catch (Throwable throwable) {
                Set set = failedModules;
                synchronized (set) {
                    if (!failedModules.contains(string)) {
                        logger.warn((Object)("Failed to create factory cache: " + throwable.getLocalizedMessage()));
                        failedModules.add(string);
                    }
                }
            }
        }
    }

    public void registerDefaultLoaders() {
        this.backend.registerDefaultLoaders();
    }

    public void registerBundleLoader(ResourceBundleLoader resourceBundleLoader) {
        if (resourceBundleLoader == null) {
            throw new NullPointerException();
        }
        this.backend.registerBundleLoader(resourceBundleLoader);
    }

    public void registerLoader(ResourceLoader resourceLoader) {
        if (resourceLoader == null) {
            throw new NullPointerException();
        }
        this.backend.registerLoader(resourceLoader);
    }

    public void registerFactory(ResourceFactory resourceFactory) {
        if (resourceFactory == null) {
            throw new NullPointerException();
        }
        this.backend.registerFactory(resourceFactory);
    }

    public void shutDown() {
        this.factoryCache.shutdown();
        this.dataCache.shutdown();
    }
}

