/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.resourceloader.factory;

import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.resourceloader.ContentNotRecognizedException;
import org.pentaho.reporting.libraries.resourceloader.LibLoaderBoot;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceFactory;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.resourceloader.factory.FactoryModule;

public abstract class AbstractResourceFactory
implements ResourceFactory {
    private HashSet factoryModules;
    private Class factoryType;

    protected AbstractResourceFactory(Class clazz) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        this.factoryType = clazz;
        this.factoryModules = new HashSet();
    }

    public Class getFactoryType() {
        return this.factoryType;
    }

    public void initializeDefaults() {
        String string = this.getFactoryType().getName();
        String string2 = "org.pentaho.reporting.libraries.resourceloader.factory.modules." + string;
        Configuration configuration = LibLoaderBoot.getInstance().getGlobalConfig();
        Iterator iterator = configuration.findPropertyKeys(string2);
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            String string4 = configuration.getConfigProperty(string3);
            Object object = ObjectUtilities.loadAndInstantiate((String)string4, AbstractResourceFactory.class, FactoryModule.class);
            if (!(object instanceof FactoryModule)) continue;
            this.registerModule((FactoryModule)object);
        }
    }

    public synchronized boolean registerModule(String string) {
        try {
            Class<?> clazz = ObjectUtilities.getClassLoader(this.getClass()).loadClass(string);
            this.registerModule((FactoryModule)clazz.newInstance());
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public synchronized void registerModule(FactoryModule factoryModule) {
        if (this.factoryModules.contains(factoryModule)) {
            return;
        }
        this.factoryModules.add(factoryModule);
    }

    public synchronized Resource create(ResourceManager resourceManager, ResourceData resourceData, ResourceKey resourceKey) throws ResourceCreationException, ResourceLoadingException {
        TreeSet<ResourceFactoryEntry> treeSet = new TreeSet<ResourceFactoryEntry>();
        for (Object object : this.factoryModules) {
            int n = object.canHandleResource(resourceManager, resourceData);
            if (n < 0) continue;
            treeSet.add(new ResourceFactoryEntry((FactoryModule)object, n));
        }
        for (ResourceFactoryEntry resourceFactoryEntry : treeSet) {
            try {
                return resourceFactoryEntry.getModule().create(resourceManager, resourceData, resourceKey);
            }
            catch (Exception exception) {
            }
        }
        throw new ContentNotRecognizedException("No valid handler for the given content.");
    }

    private static class ResourceFactoryEntry
    implements Comparable {
        private FactoryModule module;
        private int weight;

        private ResourceFactoryEntry(FactoryModule factoryModule, int n) {
            this.module = factoryModule;
            this.weight = n;
        }

        public FactoryModule getModule() {
            return this.module;
        }

        public int getWeight() {
            return this.weight;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            ResourceFactoryEntry resourceFactoryEntry = (ResourceFactoryEntry)object;
            if (this.weight != resourceFactoryEntry.weight) {
                return false;
            }
            return !(this.module != null ? !this.module.equals(resourceFactoryEntry.module) : resourceFactoryEntry.module != null);
        }

        public int hashCode() {
            int n = this.module != null ? this.module.hashCode() : 0;
            n = 31 * n + this.weight;
            return n;
        }

        public int compareTo(Object object) {
            ResourceFactoryEntry resourceFactoryEntry = (ResourceFactoryEntry)object;
            if (this.weight == resourceFactoryEntry.weight) {
                return 0;
            }
            if (this.weight < resourceFactoryEntry.weight) {
                return -1;
            }
            return 1;
        }
    }
}

