/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.resourceloader.loader.raw;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class RawResourceData
implements ResourceData {
    private ResourceKey rawKey;
    private byte[] data;

    public RawResourceData(ResourceKey resourceKey) {
        if (resourceKey == null) {
            throw new NullPointerException();
        }
        this.rawKey = resourceKey;
        this.data = (byte[])resourceKey.getIdentifier();
    }

    public byte[] getResource(ResourceManager resourceManager) throws ResourceLoadingException {
        return (byte[])this.data.clone();
    }

    public long getLength() {
        return this.data.length;
    }

    public InputStream getResourceAsStream(ResourceManager resourceManager) throws ResourceLoadingException {
        return new ByteArrayInputStream(this.data);
    }

    public int getResource(ResourceManager resourceManager, byte[] byArray, long l, int n) throws ResourceLoadingException {
        if (l > (long)this.data.length) {
            return -1;
        }
        int n2 = (int)(Integer.MAX_VALUE & l);
        int n3 = this.data.length - n2;
        int n4 = Math.min(byArray.length, Math.min(n3, n));
        System.arraycopy(this.data, n2, byArray, 0, n4);
        return n4;
    }

    public Object getAttribute(String string) {
        return null;
    }

    public ResourceKey getKey() {
        return this.rawKey;
    }

    public long getVersion(ResourceManager resourceManager) throws ResourceLoadingException {
        return -1L;
    }
}

