/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.xmlns.writer;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class CharacterEntityParser {
    private String[] charMap;
    private final HashMap entities;

    public CharacterEntityParser(Properties properties) {
        if (properties == null) {
            throw new NullPointerException("CharacterEntities must not be null");
        }
        this.entities = new HashMap<Object, Object>(properties);
        this.charMap = new String[65536];
        for (Map.Entry entry : this.entities.entrySet()) {
            String string = (String)entry.getValue();
            String string2 = (String)entry.getKey();
            if (string.length() != 1) {
                throw new IllegalStateException();
            }
            this.charMap[string.charAt((int)0)] = string2;
        }
    }

    public CharacterEntityParser(HashMap hashMap) {
        if (hashMap == null) {
            throw new NullPointerException("CharacterEntities must not be null");
        }
        this.entities = (HashMap)hashMap.clone();
        this.charMap = new String[65536];
        for (Map.Entry entry : this.entities.entrySet()) {
            String string = (String)entry.getValue();
            String string2 = (String)entry.getKey();
            if (string.length() != 1) {
                throw new IllegalStateException();
            }
            this.charMap[string.charAt((int)0)] = string2;
        }
    }

    public static CharacterEntityParser createXMLEntityParser() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("amp", "&");
        hashMap.put("quot", "\"");
        hashMap.put("lt", "<");
        hashMap.put("gt", ">");
        hashMap.put("apos", "'");
        return new CharacterEntityParser(hashMap);
    }

    private HashMap getEntities() {
        return this.entities;
    }

    private String lookupCharacter(String string) {
        return (String)this.getEntities().get(string);
    }

    public String encodeEntities(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            String string2 = this.charMap[c];
            if (string2 == null) {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append('&');
            stringBuffer.append(string2);
            stringBuffer.append(';');
        }
        return stringBuffer.toString();
    }

    public String decodeEntities(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        int n = 0;
        int n2 = string.indexOf(38, n);
        if (n2 == -1) {
            return string;
        }
        int n3 = string.indexOf(59, n2);
        if (n3 == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.substring(0, n2));
        do {
            Object object;
            if (string.charAt(n2 + 1) == '#') {
                int n4 = this.parseInt(string.substring(n2 + 2, n3), 0);
                if (n4 >= 1 && n4 <= 65536) {
                    object = new char[1];
                    object[0] = (char)n4;
                    stringBuffer.append((char[])object);
                } else {
                    stringBuffer.append(string.substring(n2, n3));
                }
            } else {
                String string2 = string.substring(n2 + 1, n3);
                object = this.lookupCharacter(string2);
                if (object != null) {
                    stringBuffer.append(this.decodeEntities((String)object));
                } else {
                    stringBuffer.append('&');
                    stringBuffer.append(string2);
                    stringBuffer.append(';');
                }
            }
            n = n3 + 1;
            n2 = string.indexOf(38, n);
            if (n2 == -1) {
                stringBuffer.append(string.substring(n));
                n3 = -1;
                continue;
            }
            n3 = string.indexOf(59, n2);
            if (n3 == -1) {
                stringBuffer.append(string.substring(n));
                continue;
            }
            stringBuffer.append(string.substring(n, n2));
        } while (n2 != -1 && n3 != -1);
        return stringBuffer.toString();
    }

    private int parseInt(String string, int n) {
        if (string == null) {
            return n;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return n;
        }
    }
}

