#ifndef __MSP430_HEADERS_PMCONTROL_H
#define __MSP430_HEADERS_PMCONTROL_H

/* pmcontrol.h
 *
 * mspgcc project: MSP430 device headers
 * Port Mapping Controller
 *
 */

/* Switches:

__MSP430_PORT_MAPPING_BASE__ - base address of the port mapping control module
__MSP430_PORT1_MAPPING_BASE__ - PORT1 present in device if defined
__MSP430_PORT2_MAPPING_BASE__ - PORT2 present in device if defined
__MSP430_PORT3_MAPPING_BASE__ - PORT3 present in device if defined

*/

#if defined(__MSP430_PORT_MAPPING_BASE__)

#define PMAPPWD_     __MSP430_PORT_MAPPING_BASE__ + 0x00  /* Port mapping password register */
#define PMAPPWD_L_   __MSP430_PORT_MAPPING_BASE__ + 0x00  /* Port mapping control register */
#define PMAPPWD_H_   __MSP430_PORT_MAPPING_BASE__ + 0x01  /* Port mapping control register */
sfrw(PMAPPWD, PMAPPWD_);                                  /* Port Mapping password register */
sfrb(PMAPPWD_L, PMAPPWD_L_);                              /* Port Mapping password register */
sfrb(PMAPPWD_H, PMAPPWD_H_);                              /* Port Mapping password register */
#define PMAPCTL_     __MSP430_PORT_MAPPING_BASE__ + 0x02  /* Port mapping password register */
#define PMAPCTL_L_   __MSP430_PORT_MAPPING_BASE__ + 0x02  /* Port mapping control register */
#define PMAPCTL_H_   __MSP430_PORT_MAPPING_BASE__ + 0x03  /* Port mapping control register */
sfrw(PMAPCTL, PMAPCTL_);                                  /* Port Mapping control register */
sfrb(PMAPCTL_L, PMAPCTL_L_);                              /* Port Mapping control register */
sfrb(PMAPCTL_H, PMAPCTL_H_);                              /* Port Mapping control register */

#define  PMAPPW                (0x2D52)       /* Port Mapping Password */

/* PMAPCTL Control Bits */
#define PMAPLOCKED             (0x0001)       /* Port Mapping Lock bit. Read only */
#define PMAPRECFG              (0x0002)       /* Port Mapping re-configuration control bit */

/* PMAPCTL Control Bits */
#define PMAPLOCKED_L           (0x0001)       /* Port Mapping Lock bit. Read only */
#define PMAPRECFG_L            (0x0002)       /* Port Mapping re-configuration control bit */

#endif /* __MSP430_PORT_MAPPING_BASE__ */

#if defined(__MSP430_PORT1_MAPPING_BASE__)

#define P1MAP01_      __MSP430_PORT1_MAPPING_BASE__ + 0x00     /* Port P1.0/1 mapping register */
#define P1MAP01_L_    __MSP430_PORT1_MAPPING_BASE__ + 0x00     /* Port P1.0/1 mapping register */
#define P1MAP01_H_    __MSP430_PORT1_MAPPING_BASE__ + 0x01     /* Port P1.0/1 mapping register */
sfrw(P1MAP01, P1MAP01_);
sfrb(P1MAP01_L, P1MAP01_L_);
sfrb(P1MAP01_H, P1MAP01_H_);
#define P1MAP23_      __MSP430_PORT1_MAPPING_BASE__ + 0x02     /* Port P1.2/3 mapping register */
#define P1MAP23_L_    __MSP430_PORT1_MAPPING_BASE__ + 0x02     /* Port P1.2/3 mapping register */
#define P1MAP23_H_    __MSP430_PORT1_MAPPING_BASE__ + 0x03     /* Port P1.2/3 mapping register */
sfrw(P1MAP23, P1MAP23_);
sfrb(P1MAP23_L, P1MAP23_L_);
sfrb(P1MAP23_H, P1MAP23_H_);
#define P1MAP45_      __MSP430_PORT1_MAPPING_BASE__ + 0x04     /* Port P1.4/5 mapping register */
#define P1MAP45_L_    __MSP430_PORT1_MAPPING_BASE__ + 0x04     /* Port P1.4/5 mapping register */
#define P1MAP45_H_    __MSP430_PORT1_MAPPING_BASE__ + 0x05     /* Port P1.4/5 mapping register */
sfrw(P1MAP45, P1MAP45_);
sfrb(P1MAP45_L, P1MAP45_L_);
sfrb(P1MAP45_H, P1MAP45_H_);
#define P1MAP67_      __MSP430_PORT1_MAPPING_BASE__ + 0x06     /* Port P1.6/7 mapping register */
#define P1MAP67_L_    __MSP430_PORT1_MAPPING_BASE__ + 0x06     /* Port P1.6/7 mapping register */
#define P1MAP67_H_    __MSP430_PORT1_MAPPING_BASE__ + 0x07     /* Port P1.6/7 mapping register */
sfrw(P1MAP67, P1MAP67_);
sfrb(P1MAP67_L, P1MAP67_L_);
sfrb(P1MAP67_H, P1MAP67_H_);

#define P1MAP0 P1MAP01_L        /* Port P1.0 mapping register */
#define P1MAP1 P1MAP01_H        /* Port P1.1 mapping register */
#define P1MAP2 P1MAP23_L        /* Port P1.2 mapping register */
#define P1MAP3 P1MAP23_H        /* Port P1.3 mapping register */
#define P1MAP4 P1MAP45_L        /* Port P1.4 mapping register */
#define P1MAP5 P1MAP45_H        /* Port P1.5 mapping register */
#define P1MAP6 P1MAP67_L        /* Port P1.6 mapping register */
#define P1MAP7 P1MAP67_H        /* Port P1.7 mapping register */

#endif /* __MSP430_PORT1_MAPPING_BASE__ */

#if defined(__MSP430_PORT2_MAPPING_BASE__)

#define P2MAP01_      __MSP430_PORT2_MAPPING_BASE__ + 0x00     /* Port P2.0/1 mapping register */
#define P2MAP01_L_    __MSP430_PORT2_MAPPING_BASE__ + 0x00     /* Port P2.0/1 mapping register */
#define P2MAP01_H_    __MSP430_PORT2_MAPPING_BASE__ + 0x01     /* Port P2.0/1 mapping register */
sfrw(P2MAP01, P2MAP01_);
sfrb(P2MAP01_L, P2MAP01_L_);
sfrb(P2MAP01_H, P2MAP01_H_);
#define P2MAP23_      __MSP430_PORT2_MAPPING_BASE__ + 0x02     /* Port P2.2/3 mapping register */
#define P2MAP23_L_    __MSP430_PORT2_MAPPING_BASE__ + 0x02     /* Port P2.2/3 mapping register */
#define P2MAP23_H_    __MSP430_PORT2_MAPPING_BASE__ + 0x03     /* Port P2.2/3 mapping register */
sfrw(P2MAP23, P2MAP23_);
sfrb(P2MAP23_L, P2MAP23_L_);
sfrb(P2MAP23_H, P2MAP23_H_);
#define P2MAP45_      __MSP430_PORT2_MAPPING_BASE__ + 0x04     /* Port P2.4/5 mapping register */
#define P2MAP45_L_    __MSP430_PORT2_MAPPING_BASE__ + 0x04     /* Port P2.4/5 mapping register */
#define P2MAP45_H_    __MSP430_PORT2_MAPPING_BASE__ + 0x05     /* Port P2.4/5 mapping register */
sfrw(P2MAP45, P2MAP45_);
sfrb(P2MAP45_L, P2MAP45_L_);
sfrb(P2MAP45_H, P2MAP45_H_);
#define P2MAP67_      __MSP430_PORT2_MAPPING_BASE__ + 0x06     /* Port P2.6/7 mapping register */
#define P2MAP67_L_    __MSP430_PORT2_MAPPING_BASE__ + 0x06     /* Port P2.6/7 mapping register */
#define P2MAP67_H_    __MSP430_PORT2_MAPPING_BASE__ + 0x07     /* Port P2.6/7 mapping register */
sfrw(P2MAP67, P2MAP67_);
sfrb(P2MAP67_L, P2MAP67_L_);
sfrb(P2MAP67_H, P2MAP67_H_);

#define P2MAP0 P2MAP01_L        /* Port P2.0 mapping register */
#define P2MAP1 P2MAP01_H        /* Port P2.1 mapping register */
#define P2MAP2 P2MAP23_L        /* Port P2.2 mapping register */
#define P2MAP3 P2MAP23_H        /* Port P2.3 mapping register */
#define P2MAP4 P2MAP45_L        /* Port P2.4 mapping register */
#define P2MAP5 P2MAP45_H        /* Port P2.5 mapping register */
#define P2MAP6 P2MAP67_L        /* Port P2.6 mapping register */
#define P2MAP7 P2MAP67_H        /* Port P2.7 mapping register */

#endif /* __MSP430_PORT2_MAPPING_BASE__ */

#if defined(__MSP430_PORT3_MAPPING_BASE__)

#define P3MAP01_      __MSP430_PORT3_MAPPING_BASE__ + 0x00     /* Port P3.0/1 mapping register */
#define P3MAP01_L_    __MSP430_PORT3_MAPPING_BASE__ + 0x00     /* Port P3.0/1 mapping register */
#define P3MAP01_H_    __MSP430_PORT3_MAPPING_BASE__ + 0x01     /* Port P3.0/1 mapping register */
sfrw(P3MAP01, P3MAP01_);
sfrb(P3MAP01_L, P3MAP01_L_);
sfrb(P3MAP01_H, P3MAP01_H_);
#define P3MAP23_      __MSP430_PORT3_MAPPING_BASE__ + 0x02     /* Port P3.2/3 mapping register */
#define P3MAP23_L_    __MSP430_PORT3_MAPPING_BASE__ + 0x02     /* Port P3.2/3 mapping register */
#define P3MAP23_H_    __MSP430_PORT3_MAPPING_BASE__ + 0x03     /* Port P3.2/3 mapping register */
sfrw(P3MAP23, P3MAP23_);
sfrb(P3MAP23_L, P3MAP23_L_);
sfrb(P3MAP23_H, P3MAP23_H_);
#define P3MAP45_      __MSP430_PORT3_MAPPING_BASE__ + 0x04     /* Port P3.4/5 mapping register */
#define P3MAP45_L_    __MSP430_PORT3_MAPPING_BASE__ + 0x04     /* Port P3.4/5 mapping register */
#define P3MAP45_H_    __MSP430_PORT3_MAPPING_BASE__ + 0x05     /* Port P3.4/5 mapping register */
sfrw(P3MAP45, P3MAP45_);
sfrb(P3MAP45_L, P3MAP45_L_);
sfrb(P3MAP45_H, P3MAP45_H_);
#define P3MAP67_      __MSP430_PORT3_MAPPING_BASE__ + 0x06     /* Port P3.6/7 mapping register */
#define P3MAP67_L_    __MSP430_PORT3_MAPPING_BASE__ + 0x06     /* Port P3.6/7 mapping register */
#define P3MAP67_H_    __MSP430_PORT3_MAPPING_BASE__ + 0x07     /* Port P3.6/7 mapping register */
sfrw(P3MAP67, P3MAP67_);
sfrb(P3MAP67_L, P3MAP67_L_);
sfrb(P3MAP67_H, P3MAP67_H_);

#define P3MAP0 P3MAP01_L        /* Port P3.0 mapping register */
#define P3MAP1 P3MAP01_H        /* Port P3.1 mapping register */
#define P3MAP2 P3MAP23_L        /* Port P3.2 mapping register */
#define P3MAP3 P3MAP23_H        /* Port P3.3 mapping register */
#define P3MAP4 P3MAP45_L        /* Port P3.4 mapping register */
#define P3MAP5 P3MAP45_H        /* Port P3.5 mapping register */
#define P3MAP6 P3MAP67_L        /* Port P3.6 mapping register */
#define P3MAP7 P3MAP67_H        /* Port P3.7 mapping register */

#endif /* __MSP430_PORT3_MAPPING_BASE__ */


#endif /* __MSP430_HEADERS_PMCONTROL_H */
